/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostgisPSFilterToSql;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.io.WKBWriter;

public class PostGISPSDialect
extends PreparedStatementSQLDialect {
    private PostGISDialect delegate;

    public PostGISPSDialect(JDBCDataStore store, PostGISDialect delegate) {
        super(store);
        this.delegate = delegate;
        this.delegate.base64EncodingEnabled = false;
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        this.delegate.addSupportedHints(hints);
    }

    public boolean isAggregatedSortSupported(String function) {
        return "distinct".equalsIgnoreCase(function);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx, hints);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx, hints);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        return this.delegate.createCRS(srid, cx);
    }

    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        return this.delegate.getMapping(columnMetaData, cx);
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getNextAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return this.delegate.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return this.delegate.encodeNextSequenceValue(schemaName, sequenceName);
    }

    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getSequenceForColumn(schemaName, tableName, columnName, cx);
    }

    public boolean isLooseBBOXEnabled() {
        return this.delegate.isLooseBBOXEnabled();
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    public void preDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.preDropTable(schemaName, featureType, cx);
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postDropTable(schemaName, featureType, cx);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        this.delegate.registerSqlTypeToSqlTypeNameOverrides(overrides);
    }

    public void handleUserDefinedType(ResultSet columnMetaData, ColumnMetadata metadata, Connection cx) throws SQLException {
        this.delegate.handleUserDefinedType(columnMetaData, metadata, cx);
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.delegate.setLooseBBOXEnabled(looseBBOXEnabled);
    }

    public boolean isEncodeBBOXFilterAsEnvelope() {
        return this.delegate.isEncodeBBOXFilterAsEnvelope();
    }

    public void setEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        this.delegate.setEncodeBBOXFilterAsEnvelope(encodeBBOXFilterAsEnvelope);
    }

    public void prepareGeometryValue(Class<? extends Geometry> gClass, int dimension, int srid, Class binding, StringBuffer sql) {
        if (gClass != null) {
            sql.append("ST_GeomFromWKB(?, " + srid + ")");
        } else {
            sql.append("?");
        }
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g != null) {
            if (g instanceof LinearRing) {
                g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
            }
            byte[] bytes = new WKBWriter(dimension).write(g);
            ps.setBytes(column, bytes);
        } else {
            ps.setNull(column, 1111, "Geometry");
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        PostgisPSFilterToSql fts = new PostgisPSFilterToSql(this);
        fts.setFunctionEncodingEnabled(this.delegate.isFunctionEncodingEnabled());
        fts.setLooseBBOXEnabled(this.delegate.isLooseBBOXEnabled());
        fts.setEncodeBBOXFilterAsEnvelope(this.delegate.isEncodeBBOXFilterAsEnvelope());
        fts.setEscapeBackslash(this.delegate.isEscapeBackslash());
        return fts;
    }

    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometryDimension(schemaName, tableName, columnName, cx);
    }

    public boolean isFunctionEncodingEnabled() {
        return this.delegate.isFunctionEncodingEnabled();
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.delegate.setFunctionEncodingEnabled(functionEncodingEnabled);
    }

    protected String getArrayComponentTypeName(AttributeDescriptor att) throws SQLException {
        if (att == null) {
            return null;
        }
        String name = (String)att.getUserData().get("org.geotools.jdbc.nativeTypeName");
        if (name != null && name.startsWith("_")) {
            return name.substring(1);
        }
        return super.getArrayComponentTypeName(att);
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        this.delegate.encodeGeometryValue(value, dimension, srid, sql);
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        this.delegate.encodeGeometryColumnSimplified(gatt, prefix, srid, sql, distance);
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        this.delegate.encodeGeometryColumnGeneralized(gatt, prefix, srid, sql, distance);
    }

    PostGISDialect getDelegate() {
        return this.delegate;
    }

    public void initializeConnection(Connection cx) throws SQLException {
        this.delegate.initializeConnection(cx);
    }

    public boolean canSimplifyPoints() {
        return this.delegate.canSimplifyPoints();
    }

    public boolean canGroupOnGeometry() {
        return this.delegate.canGroupOnGeometry();
    }

    public int getDefaultVarcharSize() {
        return this.delegate.getDefaultVarcharSize();
    }
}

