/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.csvreader.CsvReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.RelationIOException;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class CsvRelation
extends BaseRelation {
    public static final String LINE_NUM_KEY = "__linenum";
    public static final ByteOrderMark[] ACCEPTED_BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE};
    private final Supplier<Reader> dataSource;
    private final String sourceDescription;
    private final boolean includeLineNumbers;
    private Long totalRows = null;

    public static CsvRelation fromUrl(URL url) {
        return CsvRelation.fromUrl(url, false);
    }

    public static CsvRelation fromUrl(URL url, boolean includeLineNumbers) {
        Supplier<Reader> supplier = () -> {
            try {
                return CsvRelation.createInputStreamReader(url.openStream());
            }
            catch (IOException e) {
                throw new RiskscapeIOException("Failed to open stream from url " + String.valueOf(url), (Exception)e);
            }
        };
        return new CsvRelation(url.toString(), CsvRelation.inferType(supplier.get()), includeLineNumbers, supplier);
    }

    public static CsvRelation fromBytes(byte[] bytes) {
        return CsvRelation.fromBytes(bytes, false);
    }

    public static CsvRelation fromBytes(byte[] bytes, boolean includeLineNumbers) {
        Supplier<Reader> supplier = () -> CsvRelation.createInputStreamReader(new ByteArrayInputStream(bytes));
        return new CsvRelation("<anonymous>", CsvRelation.inferType(supplier.get()), includeLineNumbers, supplier);
    }

    public static Struct inferType(Reader in) {
        CsvReader reader = CsvRelation.createReader(in);
        try {
            List keys = Arrays.asList(reader.getHeaders()).stream().collect(Collectors.toList());
            Struct.StructBuilder builder = Struct.builder();
            for (String key : keys) {
                builder.add(key, (Type)Types.TEXT);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Failed to read values from csv input", (Exception)e);
        }
    }

    private static InputStreamReader createInputStreamReader(InputStream in) {
        BOMInputStream bomIn = new BOMInputStream(in, ACCEPTED_BOMS);
        try {
            String charset = bomIn.getBOMCharsetName();
            if (charset != null) {
                return new InputStreamReader((InputStream)bomIn, charset);
            }
            return new InputStreamReader((InputStream)bomIn);
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Failed to parse csv input file encoding", (Exception)e);
        }
    }

    private static CsvReader createReader(Reader in) {
        CsvReader reader = new CsvReader(in);
        try {
            reader.readHeaders();
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Failed to read headers from csv input", (Exception)e);
        }
        reader.setSkipEmptyRecords(false);
        reader.setCaptureRawRecord(true);
        return reader;
    }

    private static Struct addLineNumbers(Struct type, boolean includeLineNumbers) {
        return includeLineNumbers ? type.add(LINE_NUM_KEY, (Type)Types.INTEGER) : type;
    }

    private CsvRelation(@NonNull String sourceDescription, @NonNull Struct type, boolean includeLineNumbers, @NonNull Supplier<Reader> dataSource) {
        super(CsvRelation.addLineNumbers(type, includeLineNumbers));
        if (sourceDescription == null) {
            throw new NullPointerException("sourceDescription is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        this.includeLineNumbers = includeLineNumbers;
        this.sourceDescription = sourceDescription;
        this.dataSource = dataSource;
    }

    private CsvRelation(@NonNull BaseRelation.Fields clonedFields, @NonNull String sourceDescription, boolean includeLineNumbers, @NonNull Supplier<Reader> dataSource) {
        super(clonedFields);
        if (clonedFields == null) {
            throw new NullPointerException("clonedFields is marked non-null but is null");
        }
        if (sourceDescription == null) {
            throw new NullPointerException("sourceDescription is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        this.includeLineNumbers = includeLineNumbers;
        this.sourceDescription = sourceDescription;
        this.dataSource = dataSource;
    }

    public TupleIterator rawIterator() {
        return new Iterator();
    }

    public String getSourceInformation() {
        return this.sourceDescription;
    }

    protected CsvRelation clone(BaseRelation.Fields baseFields) {
        return new CsvRelation(baseFields, this.sourceDescription, this.includeLineNumbers, this.dataSource);
    }

    public Optional<Long> size() {
        if (this.totalRows == null) {
            BufferedReader reader = new BufferedReader(this.dataSource.get());
            long numLines = reader.lines().filter(line -> !line.isEmpty()).count();
            this.totalRows = Math.max(0L, numLines - 1L);
        }
        return Optional.of(this.totalRows);
    }

    @Generated
    public String getSourceDescription() {
        return this.sourceDescription;
    }

    private class Iterator
    extends PeekingTupleIterator {
        private final Struct type;
        private final int numMembers;
        private final CsvReader csvReader;
        private final Reader csvIn;
        private long lineIndex;

        Iterator() {
            this.type = CsvRelation.this.getRawType();
            this.numMembers = CsvRelation.this.includeLineNumbers ? this.type.getMembers().size() - 1 : this.type.getMembers().size();
            this.lineIndex = 1L;
            this.csvIn = CsvRelation.this.dataSource.get();
            this.csvReader = CsvRelation.createReader(this.csvIn);
        }

        protected String getSource() {
            return CsvRelation.this.getSourceDescription();
        }

        public Tuple get() {
            try {
                String rawRecord;
                do {
                    boolean exists = this.csvReader.readRecord();
                    ++this.lineIndex;
                    if (exists) continue;
                    return null;
                } while ((rawRecord = this.csvReader.getRawRecord()).trim().length() == 0);
                String[] values = this.csvReader.getValues();
                if (values.length != this.numMembers) {
                    throw new InvalidTupleException(Tuple.ofValues((Struct)this.type, (Object[])new Object[0]), String.format("%s:%d contained wrong number of columns - was %d, expected %d", CsvRelation.this.sourceDescription, this.lineIndex, values.length, this.numMembers));
                }
                if (CsvRelation.this.includeLineNumbers) {
                    Object[] valuesWithLineNum = new Object[values.length + 1];
                    valuesWithLineNum[values.length] = this.lineIndex;
                    System.arraycopy(values, 0, valuesWithLineNum, 0, values.length);
                    return Tuple.ofValues((Struct)this.type, (Object[])valuesWithLineNum);
                }
                return Tuple.ofValues((Struct)this.type, (Object[])values);
            }
            catch (IOException e) {
                throw new RelationIOException((Relation)CsvRelation.this, "error reading row from underlying input stream", e);
            }
        }

        public void close() {
            try {
                this.csvIn.close();
            }
            catch (IOException e) {
                throw new RelationIOException((Relation)CsvRelation.this, "error closing underlying input stream", e);
            }
        }
    }
}

