/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import lombok.Generated;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkResolvers;
import nz.org.riskscape.engine.output.FileSystemPipelineOutputStore;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.resource.CreateException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.wkt.Formattable;
import org.locationtech.jts.geom.Envelope;

public class QGSWriter {
    private static final String TEMPLATE_FILE = "/nz/org/riskscape/engine/qgis/template.xml";
    private static final String FILE = "project.qgs";
    private static final Map<String, List<?>> BOOKMARK_OPTIONS = ImmutableMap.of((Object)"validate-geometry", Arrays.asList("off"));
    public static final Consumer<FileSystemPipelineOutputStore.FileSystemPipelineContainer> WRITE_PROJECT_FILE = c -> QGSWriter.write(c);
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private XMLEventWriter writer;
    private final Map<String, SaveSink> sinks;
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final List<Layer> layers = new ArrayList<Layer>();

    public static void write(FileSystemPipelineOutputStore.FileSystemPipelineContainer container) {
        Project project = container.getProject();
        try {
            QGSWriter writer = new QGSWriter(project, container.getSinks());
            container.writeFile(FILE, "application/x-qgis-project", os -> writer.write(os));
        }
        catch (Exception e) {
            project.getProblemSink().log(PROBLEMS.errorWritingFile().withSeverity(Problem.Severity.WARNING).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
        }
    }

    public QGSWriter(Project project, Map<String, SaveSink> sinks) {
        this.sinks = sinks;
        this.generateLayers(project);
    }

    QGSWriter(Map<String, SaveSink> sinks, Function<URI, ResultOrProblems<Relation>> getRelation) {
        this.sinks = sinks;
        this.generateLayers(getRelation);
    }

    private void generateLayers(Project project) {
        BindingContext context = project.newBindingContext();
        BookmarkResolvers resolvers = project.getEngine().getBookmarkResolvers();
        this.generateLayers((URI uri) -> resolvers.getData(Bookmark.fromURI((URI)uri).addUnparsed(BOOKMARK_OPTIONS), context, Relation.class));
    }

    private void generateLayers(Function<URI, ResultOrProblems<Relation>> getRelation) {
        for (Map.Entry<String, SaveSink> entry : this.sinks.entrySet()) {
            String name = entry.getKey();
            URI uri = entry.getValue().getStoredAt();
            String source = new File(uri).toString();
            getRelation.apply(uri).ifPresent(relation -> {
                ReferencedEnvelope bounds = relation.calculateBounds().orElse(new ReferencedEnvelope(SRIDSet.EPSG4326_LONLAT));
                this.layers.add(new Layer(name, bounds, source));
            });
        }
        this.layers.sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    ReferencedEnvelope getBounds() {
        return this.getLayers().stream().map(l -> l.getBounds()).map(b -> {
            if (b.getCoordinateReferenceSystem().equals(SRIDSet.EPSG4326_LONLAT)) {
                return b;
            }
            try {
                return b.transform(SRIDSet.EPSG4326_LONLAT, false);
            }
            catch (FactoryException | TransformException throwable) {
                return new ReferencedEnvelope();
            }
        }).filter(b -> !b.isNull()).reduce(new ReferencedEnvelope(SRIDSet.EPSG4326_LONLAT), (bounds, layerBounds) -> {
            bounds.expandToInclude((Envelope)layerBounds);
            return bounds;
        });
    }

    private XMLEventReader createReader(InputStream is) throws XMLStreamException {
        return XMLInputFactory.newInstance().createXMLEventReader(is);
    }

    private XMLEventWriter createWriter(OutputStream os) throws XMLStreamException {
        return XMLOutputFactory.newInstance().createXMLEventWriter(os);
    }

    private void writeString(String s) throws XMLStreamException {
        this.writer.add(this.eventFactory.createCharacters(s));
    }

    private void writeStartElement(String name, String value, String ... attributes) throws XMLStreamException {
        this.writer.add(this.eventFactory.createStartElement("", "", name));
        int i = 0;
        while (i + 1 < attributes.length) {
            this.writer.add(this.eventFactory.createAttribute(attributes[i], attributes[i + 1]));
            i += 2;
        }
        if (!value.isEmpty()) {
            this.writeString(value);
        }
    }

    private void writeEndElement(String name) throws XMLStreamException {
        this.writer.add(this.eventFactory.createEndElement("", "", name));
    }

    private void writeElement(String name, String value, String ... attributes) throws XMLStreamException {
        this.writeStartElement(name, value, attributes);
        this.writer.add(this.eventFactory.createEndElement("", "", name));
    }

    private void writeLayerOrderLayers() throws XMLStreamException {
        for (Layer layer : this.getLayers()) {
            this.writeElement("layer", "", "id", layer.getId());
        }
    }

    private void writeMapLayers() throws XMLStreamException {
        for (Layer layer : this.getLayers()) {
            this.writeStartElement("maplayer", "", "type", "vector");
            this.writeElement("id", layer.getId(), new String[0]);
            this.writeElement("datasource", layer.getSource(), new String[0]);
            this.writeElement("layername", layer.getName(), new String[0]);
            this.writeStartElement("srs", "", new String[0]);
            this.writeStartElement("spatialrefsys", "", new String[0]);
            CoordinateReferenceSystem crs = layer.getCrs();
            if (crs != null) {
                Formattable formattableCRS = (Formattable)crs;
                String crsWKT = formattableCRS.toWKT(0).replace("\n", "");
                this.writeElement("wkt", crsWKT, new String[0]);
            } else {
                this.writeElement("wkt", "", new String[0]);
            }
            this.writeEndElement("spatialrefsys");
            this.writeEndElement("srs");
            this.writeEndElement("maplayer");
        }
    }

    private void writeLayerTreeLayers() throws XMLStreamException {
        for (Layer layer : this.getLayers()) {
            this.writeElement("layer-tree-layer", "", "name", layer.getName(), "source", layer.getSource(), "id", layer.getId());
        }
    }

    private void writeExtent() throws XMLStreamException {
        ReferencedEnvelope bounds = this.getBounds();
        String xmin = "";
        String ymin = "";
        String xmax = "";
        String ymax = "";
        if (!bounds.isNull()) {
            xmin = String.valueOf(bounds.getMinX());
            ymin = String.valueOf(bounds.getMinY());
            xmax = String.valueOf(bounds.getMaxX());
            ymax = String.valueOf(bounds.getMaxY());
        }
        this.writeStartElement("extent", "", new String[0]);
        this.writeElement("xmin", xmin, new String[0]);
        this.writeElement("ymin", ymin, new String[0]);
        this.writeElement("xmax", xmax, new String[0]);
        this.writeElement("ymax", ymax, new String[0]);
        this.writeEndElement("extent");
    }

    private void writeAll(OutputStream os) throws XMLStreamException {
        InputStream is = this.getClass().getResourceAsStream(TEMPLATE_FILE);
        XMLEventReader reader = this.createReader(is);
        this.writer = this.createWriter(os);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            this.writer.add(event);
            if (event.isStartElement()) {
                switch (event.asStartElement().getName().getLocalPart()) {
                    case "layerorder": {
                        this.writeLayerOrderLayers();
                        break;
                    }
                    case "projectlayers": {
                        this.writeMapLayers();
                        break;
                    }
                    case "mapcanvas": {
                        this.writeExtent();
                        break;
                    }
                }
                continue;
            }
            if (!event.isEndElement()) continue;
            switch (event.asEndElement().getName().getLocalPart()) {
                case "customproperties": {
                    this.writeLayerTreeLayers();
                    break;
                }
            }
        }
        this.writer.flush();
        this.writer.close();
        reader.close();
    }

    public void write(OutputStream os) throws CreateException {
        try {
            this.writeAll(os);
        }
        catch (XMLStreamException e) {
            throw new CreateException(Problems.caught((Throwable)e));
        }
    }

    @Generated
    public List<Layer> getLayers() {
        return this.layers;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem errorWritingFile();
    }

    static class Layer {
        private final String name;
        private final ReferencedEnvelope bounds;
        private final String source;
        private final UUID uuid = UUID.randomUUID();

        public String getId() {
            return (this.name + "_" + this.uuid.toString()).replace("-", "_");
        }

        public CoordinateReferenceSystem getCrs() {
            return this.bounds.getCoordinateReferenceSystem();
        }

        @Generated
        public Layer(String name, ReferencedEnvelope bounds, String source) {
            this.name = name;
            this.bounds = bounds;
            this.source = source;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ReferencedEnvelope getBounds() {
            return this.bounds;
        }

        @Generated
        public String getSource() {
            return this.source;
        }
    }
}

