/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import lombok.Generated;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.defaults.data.jdbc.GeoPackageOutputStore;
import nz.org.riskscape.engine.output.BaseJdbcPipelineOutputContainer;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.SinkParameters;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.resource.CreateException;
import nz.org.riskscape.engine.resource.CreateRequest;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class GeoPackagePipelineOutputStore
implements PipelineOutputStore {
    private final String id = "geopackage";

    public int isApplicable(URI outputLocation) {
        if ("file".equals(outputLocation.getScheme()) && outputLocation.getPath() != null && outputLocation.getPath().endsWith(".gpkg")) {
            return 1000;
        }
        return 0;
    }

    public ResultOrProblems<PipelineOutputContainer> create(URI outputLocation, RealizedPipeline pipeline, PipelineOutputOptions options) {
        File geoPackageFile;
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        Format userSpecifiedDefault = options.getFormat().orElse(null);
        if (userSpecifiedDefault != null) {
            if (!"geopackage".equals(userSpecifiedDefault.getId())) {
                warnings.add(OutputProblems.get().userSpecifiedFormatIgnored(userSpecifiedDefault, (PipelineOutputStore)this));
            }
            options.setFormat(null);
        }
        if (options.isChecksum()) {
            warnings.add(OutputProblems.get().checksumNotSupported((PipelineOutputStore)this));
        }
        if (!(geoPackageFile = new File(outputLocation)).exists()) {
            try {
                CreateRequest createRequest = new CreateRequest(geoPackageFile.getParentFile().toURI(), geoPackageFile.getName(), "application/geopackage+sqlite3");
                pipeline.getContext().getEngine().getResourceFactory().create(createRequest);
            }
            catch (CreateException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
            }
        }
        GeoPackageOutputStore backingStore = new GeoPackageOutputStore(geoPackageFile, options.isReplace());
        return ResultOrProblems.of((Object)((Object)new GeoPackagePipelineOutputContainer(this, backingStore, pipeline, options)), warnings);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    class GeoPackagePipelineOutputContainer
    extends BaseJdbcPipelineOutputContainer<GeoPackageOutputStore> {
        GeoPackagePipelineOutputContainer(PipelineOutputStore outputStore, GeoPackageOutputStore backingStore, RealizedPipeline pipeline, PipelineOutputOptions options) {
            super(outputStore, backingStore, pipeline, options);
        }

        public URI getStoredAt() {
            return ((GeoPackageOutputStore)this.backingStore).getGeoPackageFile().toURI();
        }

        @Override
        protected ResultOrProblems<SaveSink> createSink(SinkParameters parameters) {
            ArrayList<Problem> warnings = new ArrayList<Problem>();
            boolean formatMatchesOutput = parameters.getFormat().map(format -> format.getId().equals("geopackage")).orElse(true);
            if (!formatMatchesOutput) {
                warnings.add(OutputProblems.get().userSpecifiedFormatIgnored((Format)parameters.getFormat().get(), this.getStore()));
            }
            return super.createSink(parameters).withMoreProblems(warnings);
        }

        @Override
        public void close() {
            super.close();
            try {
                ((GeoPackageOutputStore)this.backingStore).close();
            }
            catch (Exception e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
        }
    }
}

