/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.output.BasePipelineOutputContainer;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.SinkParameters;
import nz.org.riskscape.engine.output.WriterConstructor;
import nz.org.riskscape.engine.pipeline.Manifest;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.resource.CreateException;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.resource.CreateRequest;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.StatsWriter;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPipelineOutputStore
implements PipelineOutputStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemPipelineOutputStore.class);
    private static final Consumer<FileSystemPipelineContainer> WRITE_STATS = container -> {
        StatsWriter writer = new StatsWriter(container.getPipeline().getContext().getMetricRegistry());
        container.writeFile("model-run-stats.csv", "text/csv", os -> writer.writeStats(os));
    };
    private final String id = "filesystem";
    private final Supplier<LocalDateTime> currentTime;
    private final List<Consumer<FileSystemPipelineContainer>> completionHooks = new ArrayList<Consumer<FileSystemPipelineContainer>>();

    public FileSystemPipelineOutputStore() {
        this(() -> LocalDateTime.now());
    }

    protected FileSystemPipelineOutputStore(Supplier<LocalDateTime> currentTime) {
        this.currentTime = currentTime;
        this.onCompletion(WRITE_STATS);
    }

    public int isApplicable(URI outputLocation) {
        return "file".equals(outputLocation.getScheme()) ? 1 : 0;
    }

    public ResultOrProblems<PipelineOutputContainer> create(URI outputLocation, RealizedPipeline pipeline, PipelineOutputOptions options) {
        CreateRequest createRequest = new CreateRequest(outputLocation, null, null, options.isReplace());
        return ResultOrProblems.of((Object)((Object)new FileSystemPipelineContainer(createRequest, pipeline, options)));
    }

    public void onCompletion(Consumer<FileSystemPipelineContainer> action) {
        this.completionHooks.add(action);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    class FileSystemPipelineContainer
    extends BasePipelineOutputContainer {
        final CreateRequest outputBase;
        final Path baseDir;

        FileSystemPipelineContainer(CreateRequest outputBase, RealizedPipeline pipeline, PipelineOutputOptions options) {
            super((PipelineOutputStore)FileSystemPipelineOutputStore.this, pipeline, options, FileSystemPipelineOutputStore.this.currentTime);
            this.outputBase = outputBase;
            this.baseDir = Paths.get(outputBase.getContainer());
        }

        public URI getStoredAt() {
            return this.outputBase.getContainer();
        }

        public void writeFile(String name, String contentType, CreateHandle.Callback writeCallback) throws CreateException {
            this.getResourceFactory().create(this.outputBase, name, contentType).store(writeCallback);
        }

        protected ResultOrProblems<SaveSink> createSink(SinkParameters params) {
            return ProblemException.catching(() -> {
                Format format = params.getFormat().orElse(this.pickDefaultFormat(params.getType()));
                String extension = com.google.common.io.Files.getFileExtension((String)params.getName());
                Object extendedName = !extension.equals(format.getExtension()) ? params.getName() + "." + format.getExtension() : params.getName();
                CreateHandle handle = this.getResourceFactory().create(this.outputBase, (String)extendedName, format.getMediaType());
                WriterConstructor writerConstructor = (WriterConstructor)format.getWriterConstructor().orElseThrow(() -> new ProblemException((Problems)GeneralProblems.get().operationNotSupported("output", format.getClass())));
                return (SaveSink)writerConstructor.newWriter(this.getExecutionContext(), params.getType(), handle, params.getFormatOptions()).map(writer -> new SaveSink(writer)).drainWarnings(p -> this.getEngine().getProblemSink().accept(p)).getOrThrow(Problems.foundWith((Object)format, (Problem[])new Problem[0]));
            });
        }

        Format pickDefaultFormat(Struct inputType) throws ProblemException {
            if (this.options.getFormat().isPresent()) {
                return (Format)this.options.getFormat().get();
            }
            if (this.containsGeometry(inputType)) {
                return (Format)this.getEngine().getFormats().getOr("shapefile").getOrThrow();
            }
            return (Format)this.getEngine().getFormats().getOr("csv").getOrThrow();
        }

        private boolean containsGeometry(Struct struct) {
            for (Struct.StructMember member : struct.getMembers()) {
                Type memberType = Nullable.strip((Type)member.getType());
                if (memberType.find(Geom.class).isPresent()) {
                    return true;
                }
                Optional structMember = memberType.find(Struct.class);
                if (!structMember.isPresent() || !this.containsGeometry((Struct)structMember.get())) continue;
                return true;
            }
            return false;
        }

        public void close() {
            this.manifest.finishTime = (LocalDateTime)this.currentTime.get();
            this.moveRegisteredFileOutputs();
            this.addOutputInfoToManifest(this.manifest);
            Optional pipelineSource = this.getPipelineSource();
            if (pipelineSource.isPresent()) {
                CreateHandle dslHandle = this.getResourceFactory().create(this.outputBase, "pipeline.txt", "text/plain");
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(dslHandle.getOutputStream()));){
                    writer.write((String)pipelineSource.get());
                }
                this.manifest.add(this.createOutputInfo("pipeline-source", dslHandle.store()));
            }
            this.writeFile("manifest.txt", "text/plain", os -> this.manifest.write(os));
            FileSystemPipelineOutputStore.this.completionHooks.forEach(action -> action.accept(this));
        }

        private void moveRegisteredFileOutputs() {
            for (Path path : this.fileOutputs) {
                try {
                    String fileName = path.getFileName().toString();
                    if (path.startsWith(this.baseDir)) {
                        URI uri = path.toFile().toURI();
                        this.movedFileOutputs.put(fileName, uri);
                        continue;
                    }
                    CreateHandle handle = this.getResourceFactory().create(this.outputBase, fileName, null);
                    Files.copy(path, handle.getOutputStream());
                    Files.delete(path);
                    this.movedFileOutputs.put(fileName, handle.store());
                }
                catch (IOException e) {
                    throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
                }
            }
        }

        private void addOutputInfoToManifest(Manifest manifest) {
            for (Map.Entry entry : this.sinks.entrySet()) {
                SaveSink instance = (SaveSink)entry.getValue();
                manifest.add(this.createOutputInfo((String)entry.getKey(), instance.getStoredAt()));
            }
            for (Map.Entry entry : this.movedFileOutputs.entrySet()) {
                manifest.add(this.createOutputInfo((String)entry.getKey(), (URI)entry.getValue()));
            }
        }

        private Manifest.OutputInfo createOutputInfo(String codename, URI outputTo) {
            String name;
            String digest;
            String size;
            if (outputTo.getScheme().equals("file")) {
                File file = new File(outputTo.getPath());
                size = Long.toString(file.length());
                if (this.options.isChecksum()) {
                    if (com.google.common.io.Files.getFileExtension((String)file.getName()).equalsIgnoreCase("shp")) {
                        log.warn("Incomplete checksum for output step '{}' - Checksumming for shp files *only* checks .shp file - not .dbx, etc - ", (Object)codename);
                    }
                    digest = this.createDigest(outputTo);
                } else {
                    digest = null;
                }
                name = file.getName();
            } else {
                log.warn("{} is not a file, manifest will be incomplete");
                size = "unknown";
                digest = null;
                name = outputTo.toString();
            }
            return new Manifest.OutputInfo(name, size, digest);
        }

        private String createDigest(URI storedAt) {
            MessageDigest digest = Manifest.getDigestInstance();
            Resource resource = this.getResourceFactory().load(storedAt);
            InputStream stream = resource.getContentStream();
            try {
                byte[] chunk = new byte[4096];
                int read = 0;
                while ((read = stream.read(chunk)) != -1) {
                    digest.update(chunk, 0, read);
                }
                String string = Manifest.checksum((MessageDigest)digest);
                return string;
            }
            catch (IOException e) {
                throw new ExitException(1, (Throwable)e, "Failed to create digest", new Object[0]);
            }
            finally {
                this.tryAndClose(stream);
            }
        }

        private void tryAndClose(AutoCloseable closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.warn("Failed to close manifest content input stream", (Throwable)e);
            }
        }
    }
}

