/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.defaults.data.jdbc.BaseJdbcOutputStore;
import nz.org.riskscape.engine.output.BasePipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.SinkParameters;
import nz.org.riskscape.engine.pipeline.Manifest;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseJdbcPipelineOutputContainer<S extends BaseJdbcOutputStore>
extends BasePipelineOutputContainer {
    public static final String MANIFEST_TABLE = "riskscape_manifest";
    public static final Struct MANIFEST_TYPE = Struct.of((String)"version", (Type)Types.TEXT, (String)"reference", (Type)Types.TEXT, (String)"started", (Type)Types.DATE, (String)"finished", (Type)Types.DATE).and("manifest", (Type)Types.TEXT).and("pipeline", (Type)Types.TEXT).and("stats", (Type)Types.TEXT).and("output_tables", (Type)RSList.create((Type)Types.TEXT));
    protected final S backingStore;
    protected final List<String> outputTables = new ArrayList<String>();

    public BaseJdbcPipelineOutputContainer(PipelineOutputStore outputStore, S backingStore, RealizedPipeline pipeline, PipelineOutputOptions options) {
        super(outputStore, pipeline, options);
        this.backingStore = backingStore;
    }

    protected ResultOrProblems<SaveSink> createSink(SinkParameters parameters) {
        return ((BaseJdbcOutputStore)this.backingStore).writerFor(parameters.getType(), parameters.getName()).flatMap(writer -> {
            this.outputTables.add(writer.getTableName());
            SaveSink sink = new SaveSink((RiskscapeWriter)writer);
            return ResultOrProblems.of((Object)sink);
        });
    }

    public void close() {
        LocalDateTime finishedAt;
        this.manifest.finishTime = finishedAt = (LocalDateTime)this.currentTime.get();
        this.addOutputInfoToManifest(this.manifest);
        ByteArrayOutputStream manifestBos = new ByteArrayOutputStream();
        this.manifest.write((OutputStream)manifestBos);
        ByteArrayOutputStream statsBos = new ByteArrayOutputStream();
        this.buildStatsWriter().writeStats((OutputStream)statsBos);
        ResultOrProblems<BaseJdbcOutputStore.JdbcRiskscapeWriter> manifestWriterOr = ((BaseJdbcOutputStore)this.backingStore).appendingWriterFor(MANIFEST_TYPE, MANIFEST_TABLE);
        if (manifestWriterOr.hasErrors()) {
            this.getProject().getProblemSink().log(OutputProblems.get().cannotWriteManifest(this.getStore(), ((BaseJdbcOutputStore)this.backingStore).getTableURI(MANIFEST_TABLE)).withChildren(manifestWriterOr.getProblems()));
        } else {
            try (RiskscapeWriter manifestWriter = (RiskscapeWriter)manifestWriterOr.drainWarnings(p -> ProblemSink.DEVNULL.log(p)).get();){
                manifestWriter.write(Tuple.ofValues((Struct)MANIFEST_TYPE, (Object[])new Object[]{this.getEngine().getBuildInfo().getVersion(), this.options.getReference(), Timestamp.valueOf(this.startedAt), Timestamp.valueOf(finishedAt), manifestBos.toString("UTF-8"), this.getPipelineSource().orElse(null), statsBos.toString("UTF-8"), this.outputTables}));
            }
            catch (IOException e) {
                throw new RiskscapeIOException(Problems.caught((Throwable)e));
            }
        }
    }

    private void addOutputInfoToManifest(Manifest manifest) {
        for (Map.Entry entry : this.sinks.entrySet()) {
            SaveSink instance = (SaveSink)entry.getValue();
            manifest.add(new Manifest.OutputInfo(instance.getStoredAt().toString(), "unknown", "unknown"));
        }
    }
}

