/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.List;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.coverage.GridCoverageRelation;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.projection.CoercerProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ToRelation
extends BaseRealizableFunction {
    public ToRelation() {
        super(ArgumentList.create((String)"coverage", (Type)CoverageType.WILD), (Type)RelationType.WILD);
    }

    protected RiskscapeFunction build(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) throws ProblemException {
        CoverageType coverageType = (CoverageType)this.getArguments().getRequiredAs(givenTypes, 0, CoverageType.class).getOrThrow();
        FunctionCall.Argument argument = (FunctionCall.Argument)this.arguments.getArgument(functionCall, "coverage").get();
        TypedCoverage constantValue = (TypedCoverage)argument.evaluateConstant(context, TypedCoverage.class, (Type)coverageType).orElse(null);
        if (constantValue != null) {
            return this.buildConstant(givenTypes, constantValue);
        }
        return this.buildDynamic(context, givenTypes, coverageType);
    }

    private RiskscapeFunction buildConstant(List<Type> givenTypes, TypedCoverage constantValue) throws ProblemException {
        Relation relation = constantValue.asRelation().orElse(null);
        if (relation == null) {
            throw new ProblemException((Problems)GeneralProblems.get().operationNotSupported("to_relation", CoverageType.class));
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
        autoCloseableArray[0] = () -> ((Relation)relation).close();
        return RiskscapeFunction.create((Object)((Object)this), givenTypes, (Type)relation.getScalarDataType(), args -> relation, (AutoCloseable[])autoCloseableArray);
    }

    private RiskscapeFunction buildDynamic(RealizationContext context, List<Type> givenTypes, CoverageType coverageType) {
        Struct valueType = GridCoverageRelation.createStructType((CoverageType)coverageType);
        return RiskscapeFunction.create((Object)((Object)this), givenTypes, (Type)new RelationType(valueType), args -> {
            TypedCoverage coverage = (TypedCoverage)args.get(0);
            Relation relation = coverage.asRelation().orElse(null);
            if (relation == null) {
                throw new RiskscapeException((Problems)GeneralProblems.get().operationNotSupported("to_relation", CoverageType.class));
            }
            if (relation.getProducedType().equals((Object)valueType)) {
                return relation;
            }
            Relation mapped = (Relation)CoercerProjection.mapping((Struct)relation.getProducedType(), (Struct)valueType, (RealizationContext)context).flatMap(projection -> relation.project((Projection)projection)).orElseThrow(probs -> new RiskscapeException(Problems.from((List)probs)));
            return mapped;
        }, (AutoCloseable[])new AutoCloseable[0]);
    }
}

