/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class SampleCoverageOne
implements RiskscapeFunction,
RealizableFunction {
    private final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("geometry", (Type)Types.GEOMETRY), new FunctionArgument("coverage", (Type)CoverageType.WILD), new FunctionArgument("buffer-distance", (Type)Types.FLOATING, Optional.of(Float.valueOf(0.0f)))});

    public List<Type> getArgumentTypes() {
        return this.getArguments().getArgumentTypes();
    }

    public Object call(List<Object> args) {
        throw new UnsupportedOperationException();
    }

    public Type getReturnType() {
        return Types.ANYTHING;
    }

    public ResultOrProblems<RiskscapeFunction> realize(final RealizationContext context, FunctionCall functionCall, final List<Type> realizeTypes) {
        Floating bufferDistanceType;
        Function<Object, Geometry> geometryExtractor;
        if (realizeTypes.size() < 2 || realizeTypes.size() > this.getArguments().size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumber(this.getArguments().size(), realizeTypes.size())});
        }
        Geom geomType = realizeTypes.get(0).find(Geom.class).orElse(null);
        if (geomType != null) {
            geometryExtractor = o -> (Geometry)o;
        } else {
            Optional<Struct.StructMember> geomMember = realizeTypes.get(0).find(Struct.class).map(struct -> TupleUtils.findGeometryMember((Struct)struct, (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL));
            if (geomMember.isPresent()) {
                geometryExtractor = o -> (Geometry)((Tuple)o).fetch((Struct.StructMember)geomMember.get());
            } else {
                return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(0), (Type)realizeTypes.get(0))});
            }
        }
        final CoverageType coverageType = realizeTypes.get(1).find(CoverageType.class).orElse(null);
        if (coverageType == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(1), (Type)realizeTypes.get(1))});
        }
        if (realizeTypes.size() == 3 && (bufferDistanceType = (Floating)realizeTypes.get(2).find(Floating.class).orElse(null)) == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(2), (Type)realizeTypes.get(2))});
        }
        return ResultOrProblems.of((Object)new RiskscapeFunction(){
            private final List<Type> argumentTypes;
            private final Type returnType;
            {
                this.argumentTypes = realizeTypes;
                this.returnType = Nullable.of((Type)coverageType.getMemberType());
            }

            public Object call(List<Object> args) {
                Geometry geom = (Geometry)geometryExtractor.apply(args.get(0));
                Point centroid = geom.getCentroid();
                TypedCoverage coverage = (TypedCoverage)args.get(1);
                Object found = GeometryUtils.getMidpoint((Geometry)geom).map(mid -> coverage.evaluate(mid)).orElse(null);
                if (found != null) {
                    return found;
                }
                Function op = coverage.getEvaluateIntersectionOp().orElse(null);
                if (op == null) {
                    throw new RiskscapeException((Problems)GeneralProblems.get().operationNotSupported("intersection", coverage.getClass()));
                }
                if (!(geom instanceof Point)) {
                    found = SampleCoverageOne.this.closestMatch((List)op.apply(geom), g -> centroid.distance(g));
                }
                if (found == null && args.size() == 3) {
                    Double bufferDistanceMetres = (Double)args.get(2);
                    if (found == null && bufferDistanceMetres > 0.0) {
                        double bufferDistanceCrsUnits = GeometryUtils.distanceToCrsUnits((double)bufferDistanceMetres, (Geometry)geom, (SRIDSet)context.getProject().getSridSet());
                        found = SampleCoverageOne.this.closestMatch((List)op.apply(geom.buffer(bufferDistanceCrsUnits)), g -> geom.distance(g));
                    }
                }
                return found;
            }

            @Generated
            public List<Type> getArgumentTypes() {
                return this.argumentTypes;
            }

            @Generated
            public Type getReturnType() {
                return this.returnType;
            }
        });
    }

    private Object closestMatch(List<Pair<Geometry, Object>> found, Function<Geometry, Double> distanceFunction) {
        if (found.isEmpty()) {
            return null;
        }
        if (found.size() == 1) {
            return found.get(0).getRight();
        }
        Pair<Geometry, Object> bestMatch = null;
        for (Pair<Geometry, Object> f : found) {
            if (bestMatch == null) {
                bestMatch = f;
                continue;
            }
            if (!(distanceFunction.apply((Geometry)f.getLeft()) < distanceFunction.apply((Geometry)bestMatch.getLeft()))) continue;
            bestMatch = f;
        }
        return bestMatch.getRight();
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }
}

