/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.IntersectionIndex;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.StructDeclaration;
import org.locationtech.jts.geom.Geometry;

public class LayerIntersections
implements RiskscapeFunction,
RealizableFunction {
    protected static final int NO_SRID_SET = -1;
    private final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("feature", (Type)Types.ANYTHING), new FunctionArgument("layer", (Type)Types.ANYTHING), new FunctionArgument("merge_attributes", (Type)Nullable.ANYTHING), new FunctionArgument("return_difference", (Type)Nullable.BOOLEAN)});
    private final List<Type> argumentTypes = this.arguments.getArgumentTypes();
    private final Type returnType = RSList.create((Type)Struct.EMPTY_STRUCT);

    public Object call(List<Object> args) {
        throw new UnsupportedOperationException();
    }

    private IndexInfo[] setupLoop(Map<String, String> mergeAttributes, Struct.StructBuilder builder, Struct lhs, Struct rhs, boolean nullable, Struct.StructMember lhsGeomMember) {
        mergeAttributes = Maps.newLinkedHashMap((Map)mergeAttributes);
        LinkedList<IndexInfo> replacements = new LinkedList<IndexInfo>();
        int targetIndex = 0;
        for (Struct.StructMember structMember : lhs.getMembers()) {
            Struct.StructMember newMember;
            String fromRhs = (String)mergeAttributes.remove(structMember.getKey());
            if (fromRhs != null) {
                Struct.StructMember rhsMember;
                newMember = rhsMember = rhs.getEntry(fromRhs);
                replacements.add(new IndexInfo(true, rhsMember.getIndex(), targetIndex));
            } else {
                if (structMember != lhsGeomMember) {
                    replacements.add(new IndexInfo(false, structMember.getIndex(), targetIndex));
                }
                newMember = structMember;
            }
            builder.add(structMember.getKey(), newMember.getType());
            ++targetIndex;
        }
        for (Map.Entry entry : mergeAttributes.entrySet()) {
            String rhsName = (String)entry.getValue();
            Struct.StructMember rhsMember = rhs.getEntry(rhsName);
            replacements.add(new IndexInfo(true, rhsMember.getIndex(), targetIndex++));
            builder.add((String)entry.getKey(), Nullable.ifTrue((boolean)nullable, (Type)rhsMember.getType()));
        }
        return replacements.toArray(new IndexInfo[replacements.size()]);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, final List<Type> givenTypes) {
        if (givenTypes.size() < 2) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(2, givenTypes.size())});
        }
        return ProblemException.catching(() -> {
            Relation cutBy = (Relation)this.arguments.evaluateConstant(context, functionCall, "layer", Relation.class, (Type)RelationType.WILD).getOrThrow();
            StructDeclaration mergeAttributesDecl = this.getMergeAttributesDeclaration(functionCall);
            Map<String, String> mergeAttributesFrom = this.createAttributeMap(mergeAttributesDecl);
            final Boolean returnDifference = givenTypes.size() == 4 ? (Boolean)this.arguments.evaluateConstant(context, functionCall, "return_difference", Boolean.class, (Type)Types.BOOLEAN).getOrThrow() : Boolean.valueOf(false);
            Struct lhs = (Struct)((Type)givenTypes.get(0)).find(Struct.class).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().mismatch((Object)((FunctionCall.Argument)functionCall.getArguments().get(0)).getExpression(), (Type)Struct.EMPTY_STRUCT, (Type)givenTypes.get(0))));
            Struct rhs = cutBy.getType();
            final Struct.StructMember lhsGeomMember = this.findGeomMember(lhs, functionCall, 0);
            Struct.StructMember rhsGeomMember = this.findGeomMember(rhs, functionCall, 1);
            Struct.StructBuilder builder = new Struct.StructBuilder();
            final IndexInfo[] indexInfos = this.setupLoop(mergeAttributesFrom, builder, lhs, rhs, returnDifference, lhsGeomMember);
            final Struct resultTypeFinal = builder.build();
            final Struct.StructMember resultGeomMember = this.findGeomMember(resultTypeFinal, null, -1);
            final RSList realizedReturnType = RSList.create((Type)resultTypeFinal);
            SRIDSet sridSet = context.getProject().getSridSet();
            final ExpensiveResource indexResource = new ExpensiveResource(context.getProblemSink(), "build index from " + ((FunctionCall.Argument)functionCall.getArguments().get(1)).toSource(), () -> {
                try {
                    return IntersectionIndex.populateFromRelation((Relation)cutBy, (Type)lhsGeomMember.getType(), (SRIDSet)sridSet, (IntersectionIndex.Options)IntersectionIndex.defaultOptions());
                }
                catch (ProblemException e) {
                    throw new RiskscapeException((Problems)e.getProblems().get(0));
                }
            });
            return new RiskscapeFunction(){

                public Type getReturnType() {
                    return realizedReturnType;
                }

                public List<Type> getArgumentTypes() {
                    return givenTypes;
                }

                public Object call(List<Object> args) {
                    List results;
                    Tuple lhs = (Tuple)args.get(0);
                    Geometry lhsGeometry = (Geometry)lhs.fetch(lhsGeomMember);
                    if (lhsGeometry == null) {
                        if (returnDifference.booleanValue()) {
                            return Collections.singletonList(this.createTuple(null, lhs, null));
                        }
                        return Collections.emptyList();
                    }
                    boolean unpackMultiGeoms = lhsGeometry.getNumGeometries() == 1;
                    IntersectionIndex index = (IntersectionIndex)indexResource.get();
                    Optional difference = null;
                    if (returnDifference.booleanValue()) {
                        Pair differenceAndIntersections = index.findDifferenceAndIntersections(lhsGeometry);
                        results = (List)differenceAndIntersections.getRight();
                        difference = (Optional)differenceAndIntersections.getLeft();
                    } else {
                        results = index.findIntersections(lhsGeometry);
                    }
                    ArrayList<Tuple> cuts = new ArrayList<Tuple>(results.size());
                    for (Pair result : results) {
                        Tuple rhsTuple = (Tuple)result.getRight();
                        Geometry rhsPiece = (Geometry)result.getLeft();
                        if (unpackMultiGeoms) {
                            GeometryUtils.processPerPart((Geometry)rhsPiece, piece -> cuts.add(this.createTuple((Geometry)piece, lhs, rhsTuple)));
                            continue;
                        }
                        cuts.add(this.createTuple(rhsPiece, lhs, rhsTuple));
                    }
                    if (returnDifference.booleanValue() && difference.isPresent()) {
                        if (unpackMultiGeoms) {
                            GeometryUtils.processPerPart((Geometry)((Geometry)difference.get()), piece -> cuts.add(this.createTuple((Geometry)piece, lhs, null)));
                        } else {
                            cuts.add(this.createTuple((Geometry)difference.get(), lhs, null));
                        }
                    }
                    return cuts;
                }

                private Tuple createTuple(Geometry geometry, Tuple lhs, Tuple rhs) {
                    Tuple tuple = new Tuple(resultTypeFinal);
                    for (IndexInfo indexInfo : indexInfos) {
                        Object toSet = indexInfo.fromRhs ? (rhs == null ? null : rhs.fetch(indexInfo.sourceIndex)) : lhs.fetch(indexInfo.sourceIndex);
                        tuple.set(indexInfo.targetIndex, toSet);
                    }
                    tuple.set(resultGeomMember, (Object)geometry);
                    return tuple;
                }
            };
        });
    }

    private Struct.StructMember findGeomMember(Struct struct, FunctionCall functionCall, int index) throws ProblemException {
        return struct.getMembers().stream().filter(member -> member.getType().findAllowNull(Geom.class).isPresent()).findFirst().orElseThrow(() -> new ProblemException((Problems)Problems.foundWith((Object)((FunctionCall.Argument)functionCall.getArguments().get(index)).getExpression(), (Problems)TypeProblems.get().structMustHaveMemberType((Type)Types.GEOMETRY, struct))));
    }

    private StructDeclaration getMergeAttributesDeclaration(FunctionCall functionCall) throws ProblemException {
        Optional arg = this.arguments.get("merge_attributes").getFunctionCallArgument(functionCall);
        if (arg.isPresent()) {
            Expression structDeclaration = ((FunctionCall.Argument)arg.get()).getExpression();
            return (StructDeclaration)structDeclaration.isA(StructDeclaration.class).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().mismatch((Object)structDeclaration, StructDeclaration.class, structDeclaration.getClass())));
        }
        return new StructDeclaration(Collections.emptyList(), Optional.empty());
    }

    private Map<String, String> createAttributeMap(StructDeclaration decl) throws ProblemException {
        HashMap<String, String> map = new HashMap<String, String>(decl.getMembers().size());
        for (StructDeclaration.Member member : decl.getMembers()) {
            Constant constant = (Constant)member.getExpression().isA(Constant.class).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().mismatch((Object)member.getExpression(), Constant.class, member.getExpression().getClass())));
            if (constant.getToken().type != TokenTypes.STRING) {
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)constant, (TokenType)TokenTypes.STRING, constant.getToken().type));
            }
            map.put(member.getIdentifier().getValue(), constant.getToken().getValue());
        }
        return map;
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    private class IndexInfo {
        final boolean fromRhs;
        final int sourceIndex;
        final int targetIndex;

        @Generated
        public IndexInfo(boolean fromRhs, int sourceIndex, int targetIndex) {
            this.fromRhs = fromRhs;
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
        }
    }
}

