/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.resource;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.net.URI;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.BaseResource;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoader;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.openstack.OSFactory;

public class SwiftObjectStorageResourceLoader
implements ResourceLoader {
    public String getId() {
        return "swift";
    }

    public String getDescription() {
        return String.format("Loads resources from an Openstack Cloud using the 'swift' APIs. URI format is: 'swift://<project-uuid>/<container-name>/<path-to-file>' Also requires the following standard Openstack environment variables to be defined:'OS_AUTH_URL', 'OS_USERNAME' and 'OS_PASSWORD'", new Object[0]);
    }

    public boolean canLoad(URI target) {
        return "swift".equals(target.getScheme());
    }

    public Resource load(URI target) {
        SwiftResource pointer = null;
        try {
            pointer = new SwiftResource(target);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceLoadingException(target, e.getMessage());
        }
        String authUrl = System.getenv("OS_AUTH_URL");
        String username = System.getenv("OS_USERNAME");
        String passwd = System.getenv("OS_PASSWORD");
        if (Strings.isNullOrEmpty((String)authUrl) || Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)passwd)) {
            throw new ResourceLoadingException(target, "Missing required swift authentication settings");
        }
        try {
            Identifier domainIdentifier = Identifier.byName((String)"Default");
            OSClient.OSClientV3 os = (OSClient.OSClientV3)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(authUrl)).credentials(username, passwd, domainIdentifier).scopeToProject(Identifier.byId((String)pointer.getProjectUUID())).authenticate();
            final SwiftObject resource = os.objectStorage().objects().get(pointer.getContainerName(), pointer.getPath());
            if (resource == null) {
                throw new ResourceLoadingException(target, String.format("Could not retrieve '%s' from object storage. Does it exist?", target));
            }
            return new BaseResource(target){

                public InputStream getContentStream() throws RiskscapeIOException {
                    return resource.download().getInputStream();
                }
            };
        }
        catch (AuthenticationException e) {
            throw new ResourceLoadingException(target, "Could not authenticate for object storage, Check connection settings and swift://<container-name>", (Throwable)e);
        }
    }

    static class SwiftResource {
        private final String projectUUID;
        private final String containerName;
        private final String path;

        SwiftResource(URI target) throws IllegalArgumentException {
            if (!"swift".equals(target.getScheme())) {
                throw new IllegalArgumentException(String.format("URI '%s' is not a swift uri", target));
            }
            this.projectUUID = target.getAuthority();
            int slash = target.getPath().indexOf("/", 1);
            if (slash == -1) {
                throw new IllegalArgumentException(String.format("URI '%s' is not a complete swift uri", target));
            }
            this.containerName = target.getPath().substring(1, slash);
            this.path = target.getPath().substring(slash + 1);
        }

        @Generated
        public String getProjectUUID() {
            return this.projectUUID;
        }

        @Generated
        public String getContainerName() {
            return this.containerName;
        }

        @Generated
        public String getPath() {
            return this.path;
        }
    }
}

