/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.auth.HttpSecret;
import nz.org.riskscape.engine.auth.SecretProblems;
import nz.org.riskscape.engine.auth.Secrets;
import nz.org.riskscape.engine.resource.BaseResource;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoader;
import nz.org.riskscape.engine.resource.ResourceProblems;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class HttpResourceLoader
implements ResourceLoader {
    private final Engine engine;

    public String getId() {
        return "http";
    }

    public String getDescription() {
        return "Load resources from the web using http/https. E.g https://riskscape.org.nz/resources/flood-project.ini";
    }

    public boolean canLoad(URI target) {
        return "http".equals(target.getScheme()) || "https".equals(target.getScheme());
    }

    HttpURLConnection getConnection(HttpSecret.Request request) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)request.getURI().toURL().openConnection();
        conn.setRequestProperty("User-Agent", String.format("RiskScape-Engine/%s", this.engine.getBuildInfo().getVersion()));
        conn.setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS));
        conn.setReadTimeout((int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        for (Pair header : request.getHeaders()) {
            conn.addRequestProperty((String)header.getLeft(), (String)header.getRight());
        }
        return conn;
    }

    public Resource load(final URI target) {
        return new BaseResource(target){

            public InputStream getContentStream() throws RiskscapeIOException {
                ResultOrProblems<InputStream> is = this.getInputStream(target);
                if (is.isPresent()) {
                    return (InputStream)is.get();
                }
                throw new RiskscapeIOException(is.getAsSingleProblem());
            }

            private ResultOrProblems<InputStream> getInputStream(URI myTarget) {
                try {
                    HttpSecret.Request request = HttpSecret.getRequest((URI)target, (Engine)HttpResourceLoader.this.engine);
                    HttpURLConnection conn = HttpResourceLoader.this.getConnection(request);
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 404) {
                        if (request.isSecretApplied()) {
                            return ResultOrProblems.failed((Problem[])new Problem[]{ResourceProblems.get().notFound(this.location, new Problem[]{SecretProblems.get().notFoundWithSecret((HttpSecret)request.getSecret().get())})});
                        }
                        return ResultOrProblems.failed((Problem[])new Problem[]{ResourceProblems.get().notFound(this.location, new Problem[0])});
                    }
                    if (responseCode == 401) {
                        Problem hint = request.getSecret().map(secret -> SecretProblems.get().secretsHint(secret)).orElseGet(() -> SecretProblems.get().noSecretsHint(Secrets.getUserHomeSecrets((Engine)HttpResourceLoader.this.engine)));
                        return ResultOrProblems.failed((Problem[])new Problem[]{ResourceProblems.get().unauthorized(this.location, new Problem[]{hint})});
                    }
                    if (responseCode == 403) {
                        return ResultOrProblems.failed((Problem[])new Problem[]{ResourceProblems.get().forbidden(this.location, new Problem[0])});
                    }
                    return ResultOrProblems.of((Object)conn.getInputStream());
                }
                catch (IOException e) {
                    throw new RiskscapeIOException(String.format("Could not access resource from '%s'", myTarget), (Exception)e);
                }
            }

            public ResultOrProblems<Path> ensureLocal(Resource.Options options) {
                return this.ensureLocal(options, null);
            }

            public ResultOrProblems<Path> ensureLocal(Resource.Options options, String extension) {
                if ("http".equals(this.location.getScheme()) && !options.allowInsecure) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{ResourceProblems.get().insecureNotAllowed(this.location)});
                }
                return super.ensureLocal(options, extension);
            }
        };
    }

    @Generated
    public HttpResourceLoader(Engine engine) {
        this.engine = engine;
    }
}

