/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class LossesByPeriod
extends BaseRealizableFunction {
    public LossesByPeriod() {
        super(ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("losses", (Type)RSList.create((Type)Types.FLOATING)), new FunctionArgument("return-periods", (Type)RSList.create((Type)Types.FLOATING)), new FunctionArgument("investigation-time", (Type)Types.INTEGER), FunctionCallOptions.options(Options.class)}), (Type)RSList.create((Type)Types.FLOATING));
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall fc, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            LossFunctionBuilder builder;
            RSList theReturnType;
            if (givenTypes.size() > this.arguments.size() || givenTypes.size() < 3) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumberRange(3, this.arguments.size(), givenTypes.size()));
            }
            RSList lossesType = (RSList)this.arguments.getRequiredAs(givenTypes, 0, RSList.class).getOrThrow();
            RSList periodsType = (RSList)this.arguments.getRequiredAs(givenTypes, 1, RSList.class).getOrThrow();
            if (!lossesType.getContainedType().isNumeric()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)((Type)givenTypes.get(0))));
            }
            if (!periodsType.getContainedType().isNumeric()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(1), (Type)((Type)givenTypes.get(1))));
            }
            this.arguments.getRequiredAs(givenTypes, 2, Integer.class).getOrThrow();
            Options options = (Options)FunctionCallOptions.bindOptionsOrThrow(Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)fc);
            if (options.mode == Mode.RANKED_CLOSEST) {
                theReturnType = lossesType;
                builder = this.closestRankedBuilder();
            } else {
                theReturnType = RSList.create((Type)Types.FLOATING);
                builder = this.percentileBuilder();
            }
            return RiskscapeFunction.create((Object)((Object)this), (List)givenTypes, (Type)theReturnType, args -> {
                ArrayList<Number> losses = new ArrayList<Number>((List)args.get(0));
                List requestedPeriods = (List)args.get(1);
                long investigationTime = (Long)args.get(2);
                LossFunction lossFunction = builder.build(losses, investigationTime);
                ArrayList<Object> results = new ArrayList<Object>(requestedPeriods.size());
                for (Number rp : requestedPeriods) {
                    if (rp.longValue() > investigationTime) {
                        throw new IllegalArgumentException("Return period " + String.valueOf(rp) + " exceeds investigation-time " + investigationTime);
                    }
                    Number loss = lossFunction.sample(rp.doubleValue());
                    results.add(theReturnType.getContainedType().coerce((Object)loss));
                }
                return results;
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    LossFunctionBuilder closestRankedBuilder() {
        return (losses, investigationTime) -> {
            losses.sort(Collections.reverseOrder());
            double[] eventRPs = this.calculateReturnPeriodsForEvents(investigationTime, losses.size());
            return rp -> this.findLossClosestToReturnPeriod(rp, eventRPs, losses);
        };
    }

    Number findLossClosestToReturnPeriod(double rp, double[] periods, List<? extends Number> losses) {
        if (rp < periods[periods.length - 1]) {
            return 0;
        }
        int index = 0;
        double closest = Double.MAX_VALUE;
        for (int i = 0; i < periods.length; ++i) {
            double diff = Math.abs(rp - periods[i]);
            if (!(diff < closest)) continue;
            closest = diff;
            index = i;
        }
        return losses.get(index);
    }

    LossFunctionBuilder percentileBuilder() {
        return (losses, investigationTime) -> {
            Percentile lossPercentile = this.buildPercentile(losses);
            return rp -> this.percentileLossForReturnPeriod(rp, lossPercentile);
        };
    }

    Percentile buildPercentile(List<Number> losses) {
        Percentile lossPercentile = new Percentile();
        lossPercentile = lossPercentile.withEstimationType(Percentile.EstimationType.R_7);
        double[] l = losses.stream().mapToDouble(Number::doubleValue).toArray();
        lossPercentile.setData(l);
        return lossPercentile;
    }

    Number percentileLossForReturnPeriod(double rp, Percentile lossPercentile) {
        double rpAsPercentile = (1.0 - 1.0 / rp) * 100.0;
        if (rpAsPercentile == 0.0) {
            return 0.0;
        }
        return lossPercentile.evaluate(rpAsPercentile);
    }

    double[] calculateReturnPeriodsForEvents(long investigationTime, int numEvents) {
        double[] periods = new double[numEvents];
        for (int n = 0; n < numEvents; ++n) {
            periods[n] = (double)investigationTime / (double)(n + 1);
        }
        return periods;
    }

    public static class Options {
        @ParameterField
        Mode mode = Mode.PERCENTILE;
    }

    @FunctionalInterface
    static interface LossFunctionBuilder {
        public LossFunction build(List<Number> var1, long var2);
    }

    @FunctionalInterface
    static interface LossFunction {
        public Number sample(double var1);
    }

    public static enum Mode {
        RANKED_CLOSEST,
        PERCENTILE;

    }
}

