/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.function;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkFactory;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WithMetadata;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class LookupBookmark
implements RealizableFunction {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final ArgumentList arguments = ArgumentList.create((String)"id", (Type)Types.TEXT, (String)"options", (Type)Types.ANYTHING, (String)"type", (Type)Types.TEXT);

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        Instance instance = new Instance(context, functionCall, givenTypes);
        if (!instance.validateArgs()) {
            return ResultOrProblems.failed(instance.problems);
        }
        if (instance.isConstant()) {
            return this.realizeConstant(instance);
        }
        return this.realizeDynamic(instance);
    }

    private ResultOrProblems<RiskscapeFunction> realizeConstant(Instance instance) {
        return instance.getConstantBookmark().flatMap(bookmark -> instance.resolveBookmark((Bookmark)bookmark)).flatMap(resolved -> {
            Problem returnTypeProblem = instance.validateBookmarkType((ResolvedBookmark)resolved);
            if (returnTypeProblem != null) {
                return ResultOrProblems.failed((Problem[])new Problem[]{returnTypeProblem});
            }
            Type returnType = WithMetadata.wrap((Type)resolved.getScalarType(), (Object[])new Object[]{resolved.getBookmark()});
            return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, instance.givenTypes, (Type)returnType, args -> resolved.getData(Object.class).get(), (AutoCloseable[])new AutoCloseable[0]));
        });
    }

    private ResultOrProblems<RiskscapeFunction> realizeDynamic(Instance instance) {
        return ProblemException.catching(() -> {
            Type expectedReturnType = instance.constantType;
            Bookmark constantBookmark = instance.constantBookmarkFromIdArg != null ? (Bookmark)instance.getConstantBookmark().getOrThrow() : null;
            return RiskscapeFunction.create((Object)this, instance.givenTypes, (Type)expectedReturnType, args -> {
                Bookmark originalBookmark;
                if (constantBookmark != null) {
                    originalBookmark = constantBookmark;
                } else {
                    String id = (String)args.get(0);
                    originalBookmark = (Bookmark)instance.lookupBookmark(id).orElseThrow(problems -> {
                        throw new RiskscapeException((Problems)Problems.foundWith((Object)instance.idArg, (List)problems));
                    });
                }
                Tuple options = (Tuple)args.get(1);
                Bookmark toResolve = options != null ? (Bookmark)instance.mergeBookmarkWithCustomOptions(originalBookmark, options).orElseThrow(problems -> {
                    throw new RiskscapeException((Problems)Problems.foundWith((Object)instance.optionsArg, (List)problems));
                }) : originalBookmark;
                return instance.context.getOrComputeFromCache(LookupBookmark.class, (Object)toResolve, Object.class, key -> {
                    ResolvedBookmark resolved = (ResolvedBookmark)instance.resolveBookmark(toResolve).orElseThrow(problems -> {
                        throw new RiskscapeException((Problems)Problems.foundWith((Object)toResolve.toString(), (List)problems));
                    });
                    Problem typeProblem = instance.validateBookmarkType(resolved);
                    if (typeProblem != null) {
                        throw new RiskscapeException((Problems)typeProblem);
                    }
                    return resolved.getData(expectedReturnType.internalType()).orElseThrow(problems -> new RiskscapeException((Problems)Problems.foundWith((Object)toResolve.toString(), (Problem[])new Problem[0])));
                });
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    class Instance {
        final RealizationContext context;
        final FunctionCall functionCall;
        final List<Type> givenTypes;
        Bookmark constantBookmarkFromIdArg;
        Tuple constantOptions;
        Type constantType;
        FunctionCall.Argument idArg;
        FunctionCall.Argument optionsArg;
        FunctionCall.Argument typeArg;
        List<Problem> problems = new ArrayList<Problem>();

        boolean validateArgs() {
            int givenArgs = this.functionCall.getArguments().size();
            if (givenArgs > LookupBookmark.this.arguments.size() || givenArgs < 1) {
                this.problems.add(ArgsProblems.get().wrongNumberRange(1, LookupBookmark.this.arguments.size(), givenArgs));
                return false;
            }
            this.idArg = (FunctionCall.Argument)LookupBookmark.this.arguments.getArgument(this.functionCall, "id").get();
            this.idArg.evaluateConstant(this.context, String.class, (Type)Types.TEXT).ifElse(id -> this.lookupBookmark((String)id).ifElse(bookmark -> {
                this.constantBookmarkFromIdArg = bookmark;
            }, probs -> this.problems.addAll((Collection<Problem>)probs)), probs -> {
                Bookmark nestedBookmark = WithMetadata.find((Type)this.givenTypes.get(0), Bookmark.class).orElse(null);
                if (nestedBookmark != null) {
                    this.constantBookmarkFromIdArg = nestedBookmark;
                } else {
                    this.idArg.evaluateConstant(this.context, Object.class, (Type)Types.ANYTHING).ifPresent(constantValue -> this.problems.add(TypeProblems.get().mismatch((Object)this.idArg, (Type)Types.TEXT, this.givenTypes.get(0))));
                }
            });
            LookupBookmark.this.arguments.getArgument(this.functionCall, "options").ifPresent(arg -> {
                this.optionsArg = arg;
                if (this.validateOptions()) {
                    arg.evaluateConstant(this.context, Tuple.class, (Type)Struct.EMPTY_STRUCT).ifPresent(optionsTuple -> {
                        this.constantOptions = optionsTuple;
                    });
                }
            });
            LookupBookmark.this.arguments.getArgument(this.functionCall, "type").ifPresent(arg -> {
                this.typeArg = arg;
                arg.evaluateConstant(this.context, String.class, (Type)Types.TEXT).ifElse(typeExp -> {
                    try {
                        this.constantType = this.context.getProject().getTypeBuilder().build(typeExp);
                    }
                    catch (RiskscapeException e) {
                        this.problems.add(Problems.caught((Throwable)e));
                    }
                }, probs -> this.problems.addAll((Collection<Problem>)probs));
            });
            if (!this.isConstant() && !this.hasErrors()) {
                if (this.constantType == null && this.constantBookmarkFromIdArg != null) {
                    Bookmark templateBookmark = this.constantBookmarkFromIdArg;
                    this.resolveBookmark(templateBookmark).ifElse(resolved -> {
                        this.constantType = resolved.getScalarType();
                    }, probs -> {
                        this.problems.addAll((Collection<Problem>)probs);
                        this.problems.add(PROBLEMS.badPlaceholderHint());
                    });
                }
                if (this.constantType == null && !this.hasErrors()) {
                    boolean added = this.problems.add(Problems.toSingleProblem((List)LookupBookmark.this.arguments.getRequiredArgument(this.functionCall, "type").getProblems()).withChildren(new Problems[]{PROBLEMS.typeRequiredHint()}));
                    assert (added);
                }
            }
            return !this.hasErrors();
        }

        ResultOrProblems<Bookmark> getConstantBookmark() {
            assert (this.constantBookmarkFromIdArg != null);
            if (this.constantOptions != null) {
                return this.mergeBookmarkWithCustomOptions(this.constantBookmarkFromIdArg, this.constantOptions);
            }
            return ResultOrProblems.of((Object)this.constantBookmarkFromIdArg);
        }

        boolean hasErrors() {
            return Problem.hasErrors(this.problems);
        }

        private ResultOrProblems<Bookmark> lookupBookmark(String idOrUri) {
            Project project = this.context.getProject();
            try {
                return ResultOrProblems.of((Object)((Bookmark)project.getBookmarks().get(idOrUri, this.context.getProblemSink())));
            }
            catch (FailedObjectException | NoSuchObjectException e) {
                URI tryThis = (URI)BookmarkFactory.uriFromLocation((String)idOrUri, (URI)this.context.getProject().getRelativeTo()).orElse(null);
                if (tryThis == null) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
                }
                return ResultOrProblems.of((Object)Bookmark.fromURI((URI)tryThis, (String)idOrUri));
            }
        }

        private ResultOrProblems<Bookmark> mergeBookmarkWithCustomOptions(Bookmark originalBookmark, Tuple optionsFromArguments) {
            Object location;
            Bookmark bookmark = originalBookmark.clone();
            Map optionsMap = optionsFromArguments.toMap();
            Object format = optionsMap.remove("format");
            if (format != null) {
                bookmark = bookmark.withFormat(format.toString());
            }
            if ((location = optionsMap.remove("location")) != null) {
                ResultOrProblems uri = UriHelper.uriFromLocation((String)location.toString(), (URI)this.context.getProject().getRelativeTo());
                if (uri.hasErrors()) {
                    return ResultOrProblems.failed((List)uri.getProblems());
                }
                bookmark = bookmark.withLocation((URI)uri.get());
            }
            return ResultOrProblems.of((Object)bookmark.addUnparsed(ParameterSet.normaliseParameterMap((Map)optionsMap)));
        }

        boolean validateOptions() {
            FunctionArgument declared = LookupBookmark.this.arguments.get("options");
            FunctionCall.Argument ast = LookupBookmark.this.arguments.getArgument(this.functionCall, "options").orElse(null);
            if (ast == null) {
                return true;
            }
            Type givenType = this.givenTypes.get(declared.getIndex());
            Struct optionsType = givenType.find(Struct.class).orElse(null);
            if (optionsType == null) {
                this.problems.add(TypeProblems.get().mismatch((Object)ast, Struct.class, givenType.getClass()));
                return false;
            }
            TypeSet typeSet = this.context.getProject().getTypeSet();
            boolean valid = true;
            for (Struct.StructMember member : optionsType.getMembers()) {
                Type memberType = member.getType().findAllowNull(RSList.class).map(list -> list.getMemberType()).orElse(member.getType());
                if (typeSet.isAssignable(memberType, (Type)Types.TEXT) || typeSet.isAssignable(memberType, (Type)Types.BOOLEAN) || typeSet.isAssignable(memberType, (Type)Types.INTEGER) || typeSet.isAssignable(memberType, (Type)Types.FLOATING)) continue;
                this.problems.add(PROBLEMS.optionValueMustBeTextNumericOrBoolean(member.getKey(), member.getType()));
                valid = false;
            }
            return valid;
        }

        public boolean isConstant() {
            return this.constantBookmarkFromIdArg != null && (this.optionsArg == null || this.constantOptions != null);
        }

        ResultOrProblems<ResolvedBookmark> resolveBookmark(Bookmark bookmark) {
            return this.context.getProject().getEngine().getBookmarkResolvers().resolveAndValidate(bookmark, this.context.getProject().newBindingContext(this.context), Object.class);
        }

        public Problem validateBookmarkType(ResolvedBookmark resolved) {
            if (this.constantType == null) {
                return null;
            }
            if (!this.context.getProject().getTypeSet().isAssignable(resolved.getScalarType(), this.constantType)) {
                String errorContext = resolved.getBookmark().toString();
                return TypeProblems.get().mismatch((Object)errorContext, this.constantType, resolved.getScalarType());
            }
            return null;
        }

        @Generated
        public Instance(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
            this.context = context;
            this.functionCall = functionCall;
            this.givenTypes = givenTypes;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem optionValueMustBeTextNumericOrBoolean(String var1, Type var2);

        @SeverityLevel(value=Problem.Severity.INFO)
        public Problem typeRequiredHint();

        @SeverityLevel(value=Problem.Severity.INFO)
        public Problem badPlaceholderHint();
    }
}

