/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import lombok.Generated;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.defaults.data.jdbc.BaseJdbcOutputStore;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.GeoPackagePipelineOutputStore;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.StructFlattener;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.locationtech.jts.geom.Geometry;

public class GeoPackageOutputStore
extends BaseJdbcOutputStore
implements AutoCloseable {
    private final File geoPackageFile;
    private Connection connection = null;

    public static ResultOrProblems<RiskscapeWriter> writerFor(File geoPackageFile, Struct type, String name, boolean replaceExistingTables) {
        GeoPackageOutputStore store = new GeoPackageOutputStore(geoPackageFile, false);
        return store.writerFor(type, name).map(writer -> new RiskscapeWriter((BaseJdbcOutputStore.JdbcRiskscapeWriter)((Object)writer), geoPackageFile, store){
            final /* synthetic */ BaseJdbcOutputStore.JdbcRiskscapeWriter val$writer;
            final /* synthetic */ File val$geoPackageFile;
            final /* synthetic */ GeoPackageOutputStore val$store;
            {
                this.val$writer = jdbcRiskscapeWriter;
                this.val$geoPackageFile = file;
                this.val$store = geoPackageOutputStore;
            }

            public void write(Tuple value) {
                this.val$writer.write(value);
            }

            public URI getStoredAt() {
                return this.val$geoPackageFile.toURI();
            }

            public void close() throws IOException {
                this.val$writer.close();
                try {
                    this.val$store.close();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    private static DataSource createDataSource(File geoPackageFile) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.sqlite.JDBC");
        ds.setUrl(String.format("jdbc:sqlite:%s", geoPackageFile.getAbsolutePath()));
        ds.setDefaultReadOnly(false);
        return ds;
    }

    public GeoPackageOutputStore(File geoPackageFile, boolean replaceExistingTables) {
        super(GeoPackageOutputStore.createDataSource(geoPackageFile), replaceExistingTables);
        this.geoPackageFile = geoPackageFile;
    }

    @Override
    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = super.getConnection();
        }
        return this.connection;
    }

    @Override
    protected BaseJdbcOutputStore.JdbcRiskscapeWriter createJdbcWriter(String tableName, List<BaseJdbcOutputStore.StructMappingToColumnMapping> mappings, Connection conn, URI storedAt) throws SQLException {
        return new BaseJdbcOutputStore.JdbcRiskscapeWriter(tableName, mappings, conn, false, storedAt);
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    protected ResultOrProblems<BaseJdbcOutputStore.StructMappingToColumnMapping> toColumnMapping(StructFlattener.StructMapping structMapping, StructFlattener.StructMapping firstGeomMapping, Connection conn) throws ProblemException {
        Class type = structMapping.getType().internalType();
        if (Geometry.class.isAssignableFrom(type)) {
            if (structMapping != firstGeomMapping) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "text", g -> g.toString()));
            }
            Referenced referenced = (Referenced)structMapping.getType().findAllowNull(Referenced.class).orElseThrow(() -> new ProblemException((Problems)GeometryProblems.get().notReferenced(structMapping.getType())));
            Optional axisSwapper = AxisSwapper.getForceXY((CoordinateReferenceSystem)referenced.getCrs(), null, (ProblemSink)ProblemSink.DEVNULL);
            CoordinateReferenceSystem crs = axisSwapper.map(AxisSwapper::getNewCrs).orElse(referenced.getCrs());
            int geoPkgSRID = this.toSridCode(crs, conn);
            GeoPkgGeomWriter geomWriter = new GeoPkgGeomWriter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, type.getSimpleName(), g -> {
                Geometry geom = (Geometry)g;
                try {
                    bos.reset();
                    geomWriter.write(this.prepareGeometry(geom, geoPkgSRID, axisSwapper), (OutputStream)bos);
                    return bos.toByteArray();
                }
                catch (IOException e) {
                    throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
                }
            }));
        }
        if (type == Boolean.class) {
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "BOOLEAN", b -> (Boolean)b != false ? 1 : 0));
        }
        if (type == Long.class) {
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "INTEGER", Function.identity()));
        }
        if (type == Double.class) {
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "REAL", Function.identity()));
        }
        if (type == Date.class) {
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT", d -> DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Date)d).getTime()))));
        }
        if (type == String.class) {
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT", Function.identity()));
        }
        return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT", x -> Objects.toString(x)), (Problem[])new Problem[]{OutputProblems.get().outputTypeAsText(structMapping.getKey(), structMapping.getType(), (PipelineOutputStore)new GeoPackagePipelineOutputStore())});
    }

    @Override
    protected void postTableCreate(String tableName, StructFlattener.StructMapping geomMapping, Connection conn) throws SQLException, ProblemException {
        if (geomMapping == null) {
            try (PreparedStatement stmt = conn.prepareStatement("insert into gpkg_contents(table_name, data_type, identifier) values(?, 'attributes', ?)");){
                stmt.setString(1, tableName);
                stmt.setString(2, tableName);
                stmt.executeUpdate();
            }
        }
        CoordinateReferenceSystem crs = geomMapping.getType().findAllowNull(Referenced.class).map(Referenced::getCrs).orElse(null);
        int geoPackageSrid = this.toSridCode(crs, conn);
        try (PreparedStatement stmt = conn.prepareStatement("insert into gpkg_contents(table_name, data_type, identifier, srs_id) values(?, 'features', ?, ?)");){
            stmt.setString(1, tableName);
            stmt.setString(2, tableName);
            stmt.setInt(3, geoPackageSrid);
            stmt.executeUpdate();
        }
        stmt = conn.prepareStatement("insert into gpkg_geometry_columns values(?, ?, ?, ?, 0, 0)");
        try {
            stmt.setString(1, tableName);
            stmt.setString(2, geomMapping.getKey());
            stmt.setString(3, geomMapping.getType().internalType().getSimpleName());
            stmt.setInt(4, geoPackageSrid);
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public URI getTableURI(String tableName) {
        return URI.create(String.format("%s?layer=%s", this.geoPackageFile.toURI(), tableName, "UTF-8"));
    }

    @Override
    protected void initDbIfNecessary(Connection conn) {
        try {
            if (!this.getExistingTableNames(conn.getMetaData()).contains("gpkg_contents")) {
                InputStream initStream = this.getClass().getResourceAsStream(String.format("/%s/geopackage-init.sql", this.getClass().getPackage().getName().replaceAll("\\.", "/")));
                this.runScript(initStream, conn);
            }
        }
        catch (IOException | SQLException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    @Override
    protected void deleteTable(String tableName, Connection conn) throws SQLException {
        List<String> existingTables = this.getExistingTableNames(conn.getMetaData());
        try (Statement stmt = conn.createStatement();){
            stmt.execute("delete from gpkg_contents where table_name = '" + tableName + "'");
            stmt.execute("delete from gpkg_geometry_columns where table_name = '" + tableName + "'");
            if (existingTables.contains("gpkg_extensions")) {
                stmt.execute("delete from gpkg_extensions where table_name = '" + tableName + "'");
            }
        }
        super.deleteTable(tableName, conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int toSridCode(CoordinateReferenceSystem crs, Connection conn) throws ProblemException {
        try (Statement stmt = conn.createStatement();){
            Integer epsgCode = null;
            try {
                epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            }
            catch (FactoryException ex) {
                throw new ProblemException((Problems)OutputProblems.get().unsupportedCrs(crs));
            }
            if (epsgCode == null) {
                if (!DefaultEngineeringCRS.class.isAssignableFrom(crs.getClass())) throw new ProblemException((Problems)OutputProblems.get().unsupportedCrs(crs));
                int ex = -1;
                return ex;
            }
            ResultSet rs = stmt.executeQuery(String.format("select srs_id from gpkg_spatial_ref_sys where organization_coordsys_id = %d and organization like 'EPSG'", epsgCode));
            if (rs.next()) {
                int n = rs.getInt("srs_id");
                return n;
            }
            try (PreparedStatement insertStmt = conn.prepareStatement("insert into gpkg_spatial_ref_sys values(?, ?, 'EPSG', ?, ?, ?)");){
                insertStmt.setString(1, "EPSG:" + epsgCode);
                insertStmt.setInt(2, epsgCode);
                insertStmt.setInt(3, epsgCode);
                insertStmt.setString(4, crs.toWKT());
                insertStmt.setString(4, "EPSG:" + epsgCode);
                insertStmt.execute();
            }
            int n = epsgCode;
            return n;
        }
        catch (SQLException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    @Generated
    public File getGeoPackageFile() {
        return this.geoPackageFile;
    }
}

