/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data.jdbc;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.output.StructFlattener;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.locationtech.jts.geom.Geometry;

public abstract class BaseJdbcOutputStore {
    public static final int DEFAULT_BATCH_INSERT_SIZE = 1000;
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    protected final DataSource ds;
    protected final boolean replaceExistingTables;

    public ResultOrProblems<JdbcRiskscapeWriter> writerFor(Struct type, String name) {
        return this.doWriterFor(type, name, false);
    }

    public ResultOrProblems<JdbcRiskscapeWriter> appendingWriterFor(Struct type, String name) {
        return this.doWriterFor(type, name, true);
    }

    protected ResultOrProblems<JdbcRiskscapeWriter> doWriterFor(Struct type, String name, boolean appending) {
        StructFlattener flattener = new StructFlattener();
        List flattened = flattener.flatten(type, (StructFlattener.Namer)new StructFlattener.LastMemberNamer());
        StructFlattener.StructMapping firstGeomMapping = flattened.stream().filter(m -> m.getType().findAllowNull(Geom.class).isPresent()).findFirst().orElse(null);
        ArrayList warnings = new ArrayList();
        Connection conn = null;
        BaseJdbcOutputStore baseJdbcOutputStore = this;
        synchronized (baseJdbcOutputStore) {
            ResultOrProblems resultOrProblems;
            block26: {
                String tableName;
                conn = this.getConnection();
                conn.setAutoCommit(false);
                DatabaseMetaData metaData2 = conn.getMetaData();
                if (name.contains(metaData2.getIdentifierQuoteString())) {
                    name = name.replaceAll(metaData2.getIdentifierQuoteString(), "_");
                }
                this.initDbIfNecessary(conn);
                ArrayList<StructMappingToColumnMapping> toColumnMappings = new ArrayList<StructMappingToColumnMapping>();
                for (StructFlattener.StructMapping sm : flattened) {
                    toColumnMappings.add((StructMappingToColumnMapping)this.toColumnMapping(sm, firstGeomMapping, conn).drainWarnings(warning -> warnings.add(warning)).getOrThrow());
                }
                List<String> existingTables = this.getExistingTableNames(metaData2);
                if (existingTables.contains(tableName = name)) {
                    if (this.replaceExistingTables && !appending) {
                        this.deleteTable(name, conn);
                    } else {
                        if (appending) {
                            try {
                                this.checkExistingTablesMatches(tableName, metaData2, toColumnMappings);
                                return ResultOrProblems.of((Object)((Object)this.createJdbcWriter(tableName, toColumnMappings, conn, this.getTableURI(this.urlEncode(tableName)))), warnings);
                            }
                            catch (ProblemException pe) {
                                return pe.toResult();
                            }
                        }
                        int counter = 1;
                        while (existingTables.contains(tableName)) {
                            tableName = String.format("%s_%d", name, counter++);
                        }
                    }
                }
                StringBuilder sb = new StringBuilder(String.format("create table %s(", this.quoteIdentifier(tableName, metaData2)));
                for (int i = 0; i < toColumnMappings.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    StructMappingToColumnMapping mapping = (StructMappingToColumnMapping)toColumnMappings.get(i);
                    sb.append(String.format("%s %s", this.quoteIdentifier(mapping.structMapping.getKey(), metaData2), mapping.dbColumnType));
                }
                sb.append(")");
                String createTableSql = sb.toString();
                Statement s = conn.createStatement();
                try {
                    s.execute(createTableSql);
                    this.postTableCreate(tableName, firstGeomMapping, conn);
                    conn.commit();
                    resultOrProblems = ResultOrProblems.of((Object)((Object)this.createJdbcWriter(tableName, toColumnMappings, conn, this.getTableURI(this.urlEncode(tableName)))), warnings);
                    if (s == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException | ProblemException e) {
                        try {
                            if (conn != null) {
                                conn.rollback();
                                conn.close();
                            }
                        }
                        catch (SQLException metaData2) {
                            // empty catch block
                        }
                        ResultOrProblems result = e instanceof ProblemException ? ((ProblemException)e).toResult() : ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
                        return result.composeProblems(PROBLEMS.failedWhen("create", this.getTableURI(this.urlEncode(name))));
                    }
                }
                s.close();
            }
            return resultOrProblems;
        }
    }

    private void checkExistingTablesMatches(String tableName, DatabaseMetaData metadata, List<StructMappingToColumnMapping> requiredMappings) throws ProblemException, SQLException {
        ResultSet rs = metadata.getColumns(null, null, tableName, null);
        ArrayList<String> existingColumns = new ArrayList<String>();
        boolean matches = true;
        int i = 0;
        while (rs.next()) {
            String existingName = rs.getString("COLUMN_NAME");
            String existingType = rs.getString("TYPE_NAME");
            if ("_text".equals(existingType) && rs.getInt("DATA_TYPE") == 2003) {
                existingType = "TEXT[]";
            }
            existingColumns.add(String.format("%s %s", existingName, existingType));
            if (i >= requiredMappings.size()) {
                matches = false;
                continue;
            }
            StructMappingToColumnMapping requiredColumn = requiredMappings.get(i++);
            if (!requiredColumn.structMapping.getKey().equals(existingName)) {
                matches = false;
            }
            if (requiredColumn.dbColumnType.equalsIgnoreCase(existingType)) continue;
            matches = false;
        }
        if (requiredMappings.size() != existingColumns.size()) {
            matches = false;
        }
        if (!matches) {
            String requiredTable = requiredMappings.stream().map(mapping -> String.format("%s %s", mapping.structMapping.getKey(), mapping.dbColumnType)).collect(Collectors.joining(", ", tableName + "(", ")"));
            String existingTable = existingColumns.stream().collect(Collectors.joining(", ", tableName + "(", ")"));
            throw new ProblemException((Problems)PROBLEMS.cannotAppendTableStructureMismatch(tableName, requiredTable, existingTable).withChildren(new Problems[]{PROBLEMS.cannotAppendTableHint()}));
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    protected JdbcRiskscapeWriter createJdbcWriter(String tableName, List<StructMappingToColumnMapping> mappings, Connection conn, URI storedAt) throws SQLException {
        return new JdbcRiskscapeWriter(tableName, mappings, conn, this.replaceExistingTables, storedAt);
    }

    protected String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String quoteIdentifier(String identifier, DatabaseMetaData metaData) throws SQLException {
        String quoteChar = metaData.getIdentifierQuoteString();
        if (identifier.contains(quoteChar)) {
            identifier = identifier.replaceAll(quoteChar, "_");
        }
        return String.format("%s%s%s", quoteChar, identifier, quoteChar);
    }

    public abstract URI getTableURI(String var1);

    protected void initDbIfNecessary(Connection conn) throws SQLException {
    }

    protected abstract ResultOrProblems<StructMappingToColumnMapping> toColumnMapping(StructFlattener.StructMapping var1, StructFlattener.StructMapping var2, Connection var3) throws ProblemException;

    protected void postTableCreate(String tableName, StructFlattener.StructMapping firstGeomMapping, Connection conn) throws SQLException, ProblemException {
    }

    protected List<String> getExistingTableNames(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (ResultSet found = metaData.getTables(null, null, "", new String[]{"TABLE", "VIEW"});){
            while (found.next()) {
                tableNames.add(found.getString("TABLE_NAME"));
            }
        }
        return tableNames;
    }

    protected void deleteTable(String tableName, Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate("drop table " + this.quoteIdentifier(tableName, conn.getMetaData()));
        }
    }

    protected void runScript(InputStream is, Connection conn) throws IOException, SQLException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));
             Statement s = conn.createStatement();){
            StringBuilder sqlBuilder = new StringBuilder();
            for (String line : CharStreams.readLines((Readable)reader)) {
                if (Strings.isNullOrEmpty((String)(line = line.trim())) || line.startsWith("--")) continue;
                sqlBuilder.append(line).append(" ");
                if (!line.endsWith(";")) continue;
                s.addBatch(sqlBuilder.toString());
                sqlBuilder.setLength(0);
            }
            s.executeBatch();
        }
    }

    protected Geometry prepareGeometry(Geometry geom, int writeSRID, Optional<AxisSwapper> axisSwapper) {
        if (axisSwapper.isPresent()) {
            geom = axisSwapper.get().swapAxis(geom);
        } else if (writeSRID != geom.getSRID()) {
            geom = geom.copy();
        }
        geom.setSRID(writeSRID);
        return geom;
    }

    @Generated
    public BaseJdbcOutputStore(DataSource ds, boolean replaceExistingTables) {
        this.ds = ds;
        this.replaceExistingTables = replaceExistingTables;
    }

    public static class StructMappingToColumnMapping {
        private final StructFlattener.StructMapping structMapping;
        private final String dbColumnType;
        private final Function<Object, Object> mapper;
        private final Optional<Integer> sqlType;

        public StructMappingToColumnMapping(StructFlattener.StructMapping structMapping, String dbColumnType, Function<Object, Object> mapper) {
            this.structMapping = structMapping;
            this.dbColumnType = dbColumnType;
            this.mapper = mapper;
            this.sqlType = Optional.empty();
        }

        @Generated
        public StructFlattener.StructMapping getStructMapping() {
            return this.structMapping;
        }

        @Generated
        public String getDbColumnType() {
            return this.dbColumnType;
        }

        @Generated
        public Function<Object, Object> getMapper() {
            return this.mapper;
        }

        @Generated
        public Optional<Integer> getSqlType() {
            return this.sqlType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructMappingToColumnMapping)) {
                return false;
            }
            StructMappingToColumnMapping other = (StructMappingToColumnMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StructFlattener.StructMapping this$structMapping = this.getStructMapping();
            StructFlattener.StructMapping other$structMapping = other.getStructMapping();
            if (this$structMapping == null ? other$structMapping != null : !this$structMapping.equals(other$structMapping)) {
                return false;
            }
            String this$dbColumnType = this.getDbColumnType();
            String other$dbColumnType = other.getDbColumnType();
            if (this$dbColumnType == null ? other$dbColumnType != null : !this$dbColumnType.equals(other$dbColumnType)) {
                return false;
            }
            Function<Object, Object> this$mapper = this.getMapper();
            Function<Object, Object> other$mapper = other.getMapper();
            if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
                return false;
            }
            Optional<Integer> this$sqlType = this.getSqlType();
            Optional<Integer> other$sqlType = other.getSqlType();
            return !(this$sqlType == null ? other$sqlType != null : !((Object)this$sqlType).equals(other$sqlType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StructMappingToColumnMapping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StructFlattener.StructMapping $structMapping = this.getStructMapping();
            result = result * 59 + ($structMapping == null ? 43 : $structMapping.hashCode());
            String $dbColumnType = this.getDbColumnType();
            result = result * 59 + ($dbColumnType == null ? 43 : $dbColumnType.hashCode());
            Function<Object, Object> $mapper = this.getMapper();
            result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
            Optional<Integer> $sqlType = this.getSqlType();
            result = result * 59 + ($sqlType == null ? 43 : ((Object)$sqlType).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping=" + String.valueOf(this.getStructMapping()) + ", dbColumnType=" + this.getDbColumnType() + ", mapper=" + String.valueOf(this.getMapper()) + ", sqlType=" + String.valueOf(this.getSqlType()) + ")";
        }

        @Generated
        public StructMappingToColumnMapping(StructFlattener.StructMapping structMapping, String dbColumnType, Function<Object, Object> mapper, Optional<Integer> sqlType) {
            this.structMapping = structMapping;
            this.dbColumnType = dbColumnType;
            this.mapper = mapper;
            this.sqlType = sqlType;
        }
    }

    public class JdbcRiskscapeWriter
    extends RiskscapeWriter {
        private final String tableName;
        private final List<StructMappingToColumnMapping> mappings;
        private final Connection conn;
        private final boolean closeConnection;
        private final PreparedStatement insertStmt;
        private final URI storedAt;
        private final AtomicInteger tupleCounter = new AtomicInteger();

        JdbcRiskscapeWriter(String tableName, List<StructMappingToColumnMapping> mappings, Connection conn, boolean closeConnection, URI storedAt) throws SQLException {
            this.tableName = tableName;
            this.mappings = mappings;
            this.conn = conn;
            this.closeConnection = closeConnection;
            this.storedAt = storedAt;
            this.insertStmt = conn.prepareStatement(String.format("insert into %s values(%s)", BaseJdbcOutputStore.this.quoteIdentifier(tableName, conn.getMetaData()), Joiner.on((String)",").join(Collections.nCopies(mappings.size(), "?"))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Tuple tuple) {
            block8: {
                try {
                    for (int i = 0; i < this.mappings.size(); ++i) {
                        StructMappingToColumnMapping mapping = this.mappings.get(i);
                        Object value = mapping.structMapping.getAccessExpression().evaluate((Object)tuple);
                        if (value != null) {
                            value = mapping.mapper.apply(value);
                        }
                        if (mapping.sqlType.isPresent()) {
                            this.insertStmt.setObject(i + 1, value, mapping.sqlType.get());
                            continue;
                        }
                        this.insertStmt.setObject(i + 1, value);
                    }
                    this.insertStmt.executeUpdate();
                    if (this.tupleCounter.incrementAndGet() % 1000 != 0) break block8;
                    Connection i = this.conn;
                    synchronized (i) {
                        this.conn.commit();
                    }
                }
                catch (SQLException e) {
                    throw new RiskscapeException((Problems)PROBLEMS.failedWhen("write", this.storedAt).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                Connection connection = this.conn;
                synchronized (connection) {
                    this.insertStmt.close();
                    this.conn.commit();
                    if (this.closeConnection) {
                        this.conn.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public URI getStoredAt() {
            return this.storedAt;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem failedWhen(String var1, URI var2);

        public Problem cannotAppendTableStructureMismatch(String var1, String var2, String var3);

        @SeverityLevel(value=Problem.Severity.INFO)
        public Problem cannotAppendTableHint();
    }
}

