/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.opengis.ows11.DomainType;
import net.opengis.ows11.OperationType;
import net.opengis.wfs20.WFSCapabilitiesType;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.auth.HttpSecret;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.projection.ForceSridProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.PagingFeatureSourceRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.eclipse.emf.common.util.EList;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.util.Version;

public class WfsBookmarkResolver
extends FeatureSourceBookmarkResolver<WFSDataStore, WfsParams> {
    private static final int DEFAULT_WFS_PAGE_SIZE = 100000;
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final WFSDataStoreFactory dataStoreFactory = new WFSDataStoreFactory();

    public WfsBookmarkResolver(Engine engine) {
        super(engine);
    }

    protected WFSDataStore createDataStore(WfsParams params) throws MalformedURLException, IOException {
        HttpSecret.Request request = HttpSecret.getRequest((URI)params.getLocation(), (Engine)this.engine);
        ImmutableMap dsParams = ImmutableMap.of((Object)WFSDataStoreFactory.TIMEOUT.key, (Object)600000, (Object)WFSDataStoreFactory.URL.key, (Object)request.getURI().toURL(), (Object)WFSDataStoreFactory.ADDITIONAL_HEADERS.key, request.getHeaders().stream().collect(Collectors.toMap(p -> (String)p.getLeft(), p -> (String)p.getRight())));
        try {
            return this.dataStoreFactory.createDataStore((Map)dsParams);
        }
        catch (IOException ex) {
            throw new RiskscapeException((Problems)PROBLEMS.badWfsTarget(params.getLocation()).withChildren(new Problems[]{Problems.caught((Throwable)ex)}));
        }
    }

    protected ResultOrProblems<Relation> wrapRelation(WfsParams params, WFSDataStore dataStore, FeatureSourceRelation relation, CoordinateReferenceSystem crs) {
        String versionString = dataStore.getInfo().getVersion();
        ResultOrProblems wrapped = versionString != null && new Version(versionString).equals((Object)Versions.v2_0_0) ? ResultOrProblems.of((Object)new PagingFeatureSourceRelation(relation.getType(), relation.getFeatureSource(), relation.getSridSet(), (Filter)Filter.INCLUDE, crs, this.getPageSize(dataStore.getWfsClient().getCapabilities(), params.wfsPageSize))) : ResultOrProblems.of((Object)relation);
        if (!params.crs.isPresent()) {
            return wrapped.flatMap(rel -> rel.project((Projection)new ForceSridProjection(crs, relation.getSridSet())));
        }
        return wrapped;
    }

    int getPageSize(WFSGetCapabilities serverCapabilities, int userSpecifiedPageSize) {
        Integer serverPageSize = null;
        if (serverCapabilities.getParsedCapabilities() instanceof WFSCapabilitiesType) {
            WFSCapabilitiesType wfsCapabilities = (WFSCapabilitiesType)serverCapabilities.getParsedCapabilities();
            EList operationTypes = wfsCapabilities.getOperationsMetadata().getOperation();
            for (OperationType operationType : operationTypes) {
                if (!"GetFeature".equals(operationType.getName())) continue;
                EList constraints = operationType.getConstraint();
                serverPageSize = this.getCountDefaultConstraint((List<DomainType>)constraints);
                break;
            }
            if (serverPageSize == null) {
                EList constraints = wfsCapabilities.getOperationsMetadata().getConstraint();
                serverPageSize = this.getCountDefaultConstraint((List<DomainType>)constraints);
            }
        }
        if (serverPageSize == null || serverPageSize > userSpecifiedPageSize) {
            return userSpecifiedPageSize;
        }
        return serverPageSize;
    }

    private Integer getCountDefaultConstraint(List<DomainType> constraints) {
        for (DomainType constraint : constraints) {
            if (!"CountDefault".equals(constraint.getName())) continue;
            try {
                int countDefault = Integer.parseInt(constraint.getDefaultValue().getValue());
                if (countDefault <= 0) continue;
                return countDefault;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }

    public String getFormat(Bookmark bookmark) {
        String format = super.getFormat(bookmark);
        if (Strings.isNullOrEmpty((String)format)) {
            URI location = bookmark.getLocation();
            String scheme = location.getScheme();
            String path = location.getPath();
            if (scheme != null && scheme.startsWith("http") && path != null && path.toLowerCase().contains("/wfs")) {
                return "wfs";
            }
        }
        return format;
    }

    public Set<String> getFormats() {
        return Collections.singleton("wfs");
    }

    protected Map<String, String> getExtensionsToFormats() {
        return Collections.emptyMap();
    }

    public static class WfsParams
    extends RelationBookmarkParams {
        @ParameterField
        public int wfsPageSize = 100000;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem badWfsTarget(URI var1);
    }
}

