/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Map;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class ShapefileBookmarkResolver
extends FeatureSourceBookmarkResolver<ShapefileDataStore, RelationBookmarkParams> {
    public static final Map<String, String> EXTENSIONS_TO_FORMATS = ImmutableMap.of((Object)"shp", (Object)"shapefile");
    private final ShapefileDataStoreFactory datastoreFactory = new ShapefileDataStoreFactory();

    public ShapefileBookmarkResolver(Engine engine) {
        super(engine);
        System.setProperty("org.geotools.shapefile.enableCPG", "true");
    }

    protected ShapefileDataStore createDataStore(RelationBookmarkParams bookmark) throws MalformedURLException, IOException {
        Path shapefile = this.getBookmarkedPath((BookmarkParameters)bookmark);
        return (ShapefileDataStore)this.datastoreFactory.createDataStore(shapefile.toUri().toURL());
    }

    protected Problems checkDataValid(RelationBookmarkParams params, ShapefileDataStore dataStore) {
        try {
            this.createFeatureSource(params, (DataStore)dataStore).map(sfs -> (SimpleFeatureType)sfs.getSchema());
            return null;
        }
        catch (RuntimeException ex) {
            return Problems.caught((Throwable)ex);
        }
    }

    protected Map<String, String> getExtensionsToFormats() {
        return EXTENSIONS_TO_FORMATS;
    }

    protected JavaParameterSet<RelationBookmarkParams> buildParameterSet() {
        RelationBookmarkParams params = new RelationBookmarkParams();
        params.crsLongitudeFirst = true;
        return JavaParameterSet.fromBindingInstance(RelationBookmarkParams.class, (Object)params);
    }
}

