/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.geotools.geopkg.GeoPkgDataStoreFactory;

public class RsGpkgDataStoreFactory
extends GeoPkgDataStoreFactory {
    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        String database = params.get("database").toString();
        Path databasePath = Paths.get(database, new String[0]);
        StringBuilder url = new StringBuilder();
        url.append("jdbc:sqlite:file:");
        url.append(database.toString());
        if (this.isNeedImmutable(databasePath)) {
            url.append("?immutable=true");
        }
        return url.toString();
    }

    boolean isNeedImmutable(Path databasePath) {
        return Files.exists(databasePath, new LinkOption[0]) && !Files.isWritable(databasePath.getParent()) && !Files.isWritable(databasePath);
    }
}

