/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.BookmarkProblems;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.FeatureSourceTupleIterator;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureIterator;
import org.geotools.kml.v22.KML;
import org.geotools.kml.v22.KMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.PullParser;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.xml.sax.SAXException;

public class KmlResolver
extends RelationBookmarkResolver<RelationBookmarkParams> {
    public static final String GEOM_KEY = "Geometry";
    private Map<String, String> extensionsToFormats = ImmutableMap.of((Object)"kml", (Object)"kml");

    public KmlResolver(Engine engine) {
        super(engine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultOrProblems<Relation> createRawRelationFromBookmark(RelationBookmarkParams params) {
        ResultOrProblems kmlFile = this.getBookmarkedPathOr((BookmarkParameters)params);
        if (kmlFile.hasProblems()) {
            return ResultOrProblems.failed((List)kmlFile.getProblems());
        }
        GeometryFactory crs84Factory = params.getProject().getSridSet().getGeometryFactory(SRIDSet.EPSG4326_LONLAT);
        SimpleFeatureType featureType = null;
        try (KmlFeatureReader reader = new KmlFeatureReader(params.bookmark, Files.newInputStream((Path)kmlFile.get(), new OpenOption[0]), crs84Factory);){
            if (reader.type == null) {
                ResultOrProblems resultOrProblems = ResultOrProblems.failed((Problem[])new Problem[]{BookmarkProblems.get().invalidContent("KML")});
                return resultOrProblems;
            }
            featureType = reader.type;
        }
        catch (RiskscapeException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{e.getProblem()});
        }
        catch (IOException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
        Struct type = FeatureSourceRelation.fromFeatureType((SimpleFeatureType)featureType, null, (boolean)false);
        Struct.StructBuilder builder = Struct.builder();
        Struct.StructMember geomMember = type.getEntry(GEOM_KEY);
        builder.add(geomMember.getKey(), Referenced.of((Type)geomMember.getType(), (CoordinateReferenceSystem)SRIDSet.EPSG4326_LONLAT));
        Iterator iterator = type.getMembers().iterator();
        while (iterator.hasNext()) {
            Struct.StructMember member = (Struct.StructMember)iterator.next();
            if (member == geomMember) continue;
            Type memberType = member.getType();
            if (Geometry.class.isAssignableFrom(memberType.internalType())) {
                memberType = Referenced.of((Type)memberType, (CoordinateReferenceSystem)SRIDSet.EPSG4326_LONLAT);
            }
            builder.add(member.getKey(), memberType);
        }
        return ResultOrProblems.of((Object)((Object)new KmlRelation(builder.build(), params.bookmark, (Path)kmlFile.get(), crs84Factory)));
    }

    @Generated
    public Map<String, String> getExtensionsToFormats() {
        return this.extensionsToFormats;
    }

    private static class KmlFeatureReader
    implements FeatureIterator<SimpleFeature> {
        private final Bookmark bookmark;
        private final SimpleFeatureType type;
        private final PullParser parser;
        private final InputStream is;
        private SimpleFeature next = null;

        KmlFeatureReader(Bookmark bookmark, InputStream is, GeometryFactory geometryFactory) {
            this.bookmark = bookmark;
            this.is = is;
            KMLConfiguration config = new KMLConfiguration();
            config.getContext().registerComponentInstance((Object)geometryFactory);
            this.parser = new PullParser((Configuration)config, is, KML.Placemark);
            this.getNext();
            this.type = this.next != null ? this.next.getType() : null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.type;
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SimpleFeature toReturn = this.next;
            this.getNext();
            return toReturn;
        }

        private void getNext() {
            try {
                this.next = (SimpleFeature)this.parser.parse();
            }
            catch (XMLStreamException | SAXException e) {
                Problem invalidProblem = BookmarkProblems.get().invalidContent("KML").withException((Throwable)e);
                if (this.next != null) {
                    throw new RiskscapeException((Problems)Problems.foundWith((Object)this.bookmark, (Problems)invalidProblem));
                }
                throw new RiskscapeException((Problems)invalidProblem);
            }
            catch (IOException e) {
                throw new RiskscapeIOException(Problems.caught((Throwable)e));
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void close() {
            try {
                this.is.close();
            }
            catch (IOException e) {
                throw new RiskscapeIOException(Problems.caught((Throwable)e));
            }
        }
    }

    public static class KmlRelation
    extends BaseRelation {
        private final Bookmark bookmark;
        private final Path kmlFile;
        private final GeometryFactory crs84Factory;

        public KmlRelation(Struct type, Bookmark bookmark, Path kmlFile, GeometryFactory crs84Factory) {
            super(type, null, new SpatialMetadata(SRIDSet.EPSG4326_LONLAT, type.getEntry(KmlResolver.GEOM_KEY)));
            this.bookmark = bookmark;
            this.kmlFile = kmlFile;
            this.crs84Factory = crs84Factory;
        }

        public KmlRelation(BaseRelation.Fields fields, Bookmark bookmark, Path kmlFile, GeometryFactory crs84Factory) {
            super(fields);
            this.bookmark = bookmark;
            this.kmlFile = kmlFile;
            this.crs84Factory = crs84Factory;
        }

        protected TupleIterator rawIterator() {
            KmlFeatureReader reader;
            try {
                reader = new KmlFeatureReader(this.bookmark, Files.newInputStream(this.kmlFile, new OpenOption[0]), this.crs84Factory);
            }
            catch (Exception e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
            return new FeatureSourceTupleIterator((FeatureIterator)reader, this.getRawType());
        }

        protected BaseRelation clone(BaseRelation.Fields fields) {
            return new KmlRelation(fields, this.bookmark, this.kmlFile, this.crs84Factory);
        }

        public String getSourceInformation() {
            return this.kmlFile.toString();
        }
    }
}

