/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.defaults.data.RsGpkgDataStoreFactory;
import nz.org.riskscape.engine.projection.ForceSridProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.data.DataStore;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geopkg.GeoPkgDataStoreFactory;

public class GeoPackageRelationResolver
extends FeatureSourceBookmarkResolver<DataStore, RelationBookmarkParams> {
    public static final Map<String, String> EXTENSIONS_TO_FORMATS = ImmutableMap.of((Object)"gpkg", (Object)"geopackage");
    private final GeoPkgDataStoreFactory datastoreFactory = new RsGpkgDataStoreFactory();

    public GeoPackageRelationResolver(Engine engine) {
        super(engine);
    }

    protected DataStore createDataStore(RelationBookmarkParams bookmark) throws MalformedURLException, IOException {
        Path geopkgPath = this.getBookmarkedPath((BookmarkParameters)bookmark);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbtype", "geopkg");
        params.put("database", geopkgPath.toString());
        params.put("read_only", true);
        return this.datastoreFactory.createDataStore(params);
    }

    protected Problems checkDataValid(RelationBookmarkParams params, DataStore dataStore) {
        try {
            dataStore.getTypeNames();
            return null;
        }
        catch (IOException | RuntimeException ex) {
            return Problems.caught((Throwable)ex);
        }
    }

    protected Map<String, String> getExtensionsToFormats() {
        return EXTENSIONS_TO_FORMATS;
    }

    protected JavaParameterSet<RelationBookmarkParams> buildParameterSet() {
        RelationBookmarkParams params = new RelationBookmarkParams();
        params.crsLongitudeFirst = true;
        return JavaParameterSet.fromBindingInstance(RelationBookmarkParams.class, (Object)params);
    }

    protected ResultOrProblems<Relation> wrapRelation(RelationBookmarkParams params, DataStore dataStore, FeatureSourceRelation relation, CoordinateReferenceSystem crs) {
        return relation.project((Projection)new ForceSridProjection(crs, params.getProject().getSridSet()));
    }
}

