/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.projection.ForceSridProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.FeatureSourceTupleIterator;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geojson.feature.FeatureJSON;
import org.json.simple.parser.ParseException;

public class GeoJSONResolver
extends RelationBookmarkResolver<RelationBookmarkParams> {
    private Map<String, String> extensionsToFormats = ImmutableMap.of((Object)"geojson", (Object)"geojson", (Object)"json", (Object)"geojson");

    public GeoJSONResolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems<Relation> createRawRelationFromBookmark(RelationBookmarkParams params) {
        FeatureJSON featureJSON = new FeatureJSON();
        ResultOrProblems geojsonFile = this.getBookmarkedPathOr((BookmarkParameters)params);
        if (geojsonFile.hasProblems()) {
            return ResultOrProblems.failed((List)geojsonFile.getProblems());
        }
        try {
            SimpleFeatureType simpleType = featureJSON.readFeatureCollectionSchema((Object)((Path)geojsonFile.get()).toFile(), true);
            featureJSON.setFeatureType(simpleType);
            FeatureCollection featureCollection = featureJSON.readFeatureCollection((Object)((Path)geojsonFile.get()).toFile());
            Struct type = FeatureSourceRelation.fromFeatureType((SimpleFeatureType)simpleType, null, (boolean)false);
            GeoJSONRelation relation = new GeoJSONRelation(type, featureCollection, params.bookmark.toString());
            Struct.StructMember geometryMember = TupleUtils.findGeometryMember((Struct)relation.getType(), (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
            if (geometryMember == null) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)"GeoJSON", (Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{relation.getType()}))});
            }
            return relation.project((Projection)new ForceSridProjection(SRIDSet.EPSG4326_LONLAT, params.getProject().getSridSet()));
        }
        catch (IOException | IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof ParseException) {
                return ResultOrProblems.failed((Problem[])new Problem[]{FileProblems.get().geotoolsCannotRead(((Path)geojsonFile.get()).toFile()).withChildren(new Problems[]{Problems.caught((Throwable)cause)}), FileProblems.get().badGeospatialDataTip(((Path)geojsonFile.get()).toFile(), "GeoJSON")});
            }
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
    }

    @Generated
    public Map<String, String> getExtensionsToFormats() {
        return this.extensionsToFormats;
    }

    public static class GeoJSONRelation
    extends BaseRelation {
        private final FeatureCollection featureCollection;
        private final String sourceInformation;

        public GeoJSONRelation(BaseRelation.Fields fields, FeatureCollection featureCollection, String sourceInformation) {
            super(fields);
            this.featureCollection = featureCollection;
            this.sourceInformation = sourceInformation;
        }

        public GeoJSONRelation(Struct type, FeatureCollection featureCollection, String sourceInformation) {
            super(type);
            this.featureCollection = featureCollection;
            this.sourceInformation = sourceInformation;
        }

        protected TupleIterator rawIterator() {
            FeatureIterator featureIterator = this.featureCollection.features();
            return new FeatureSourceTupleIterator(featureIterator, this.getRawType());
        }

        protected BaseRelation clone(BaseRelation.Fields fields) {
            return new GeoJSONRelation(fields, this.featureCollection, this.sourceInformation);
        }

        public Optional<Long> size() {
            return Optional.of(Long.valueOf(this.featureCollection.size()));
        }

        @Generated
        public String getSourceInformation() {
            return this.sourceInformation;
        }
    }
}

