/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.resource.BaseResource;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoader;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.problem.Problems;

public class DataURILoader
implements ResourceLoader {
    private final Engine engine;
    public static final Charset DEFAULT_ENCODING = StandardCharsets.US_ASCII;

    public String getId() {
        return "data";
    }

    public String getDescription() {
        return "Supports data embedded in URIs (RFC-2397)";
    }

    public boolean canLoad(URI target) {
        return this.getId().equals(target.getScheme());
    }

    public Resource load(URI target) throws ResourceLoadingException {
        byte[] bytes;
        String[] mediaTypeSplit;
        String specificPart = target.getRawSchemeSpecificPart();
        String[] mediaTypeAndData = specificPart.split(",");
        if (mediaTypeAndData.length != 2) {
            throw new ResourceLoadingException(target, "");
        }
        String mediaTypePart = mediaTypeAndData[0].trim();
        boolean base64 = false;
        String base64Suffix = ";base64";
        if (mediaTypePart.endsWith(";base64")) {
            base64 = true;
            mediaTypePart = mediaTypePart.substring(mediaTypePart.length() - ";base64".length());
        }
        Charset charset = DEFAULT_ENCODING;
        for (String bit : mediaTypeSplit = mediaTypePart.split(";")) {
            String[] keyValue = bit.split("=");
            if (!keyValue[0].equals("charset")) continue;
            charset = Charset.forName(keyValue[1]);
        }
        final String mediaType = Strings.isNullOrEmpty((String)mediaTypePart) ? "text/plain" : mediaTypePart;
        String dataPart = mediaTypeAndData[1];
        try {
            bytes = base64 ? Base64.getUrlDecoder().decode(dataPart.getBytes(DEFAULT_ENCODING)) : URLDecoder.decode(dataPart, charset).getBytes();
        }
        catch (IllegalArgumentException e) {
            throw new ResourceLoadingException(target, Problems.caught((Throwable)e));
        }
        return new BaseResource(target){

            public InputStream getContentStream() throws RiskscapeIOException {
                return new ByteArrayInputStream(bytes);
            }

            public Optional<String> getMediaType() {
                return Optional.of(mediaType);
            }
        };
    }

    @Generated
    public DataURILoader(Engine engine) {
        this.engine = engine;
    }
}

