/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults.data;

import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.projection.TypeProjection;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.CsvRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;

public class CsvResolver
extends RelationBookmarkResolver<CsvParams> {
    public static final Map<String, String> EXTENSIONS_TO_FORMATS = ImmutableMap.of((Object)"csv", (Object)"csv");
    private static final String DEFAULT_GEOMETRY_ATTRIBUTE = "the_geom";

    public CsvResolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems<Relation> createRawRelationFromBookmark(CsvParams params) {
        CsvRelation fromUrl;
        URL url;
        try {
            ResultOrProblems csv = this.getBookmarkedPathOr((BookmarkParameters)params);
            if (csv.hasProblems()) {
                return ResultOrProblems.failed((List)csv.getProblems());
            }
            url = ((Path)csv.get()).toUri().toURL();
        }
        catch (MalformedURLException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Failed to open URI '%s' - %s", (Object[])new Object[]{params.getLocation(), e})});
        }
        try {
            fromUrl = CsvRelation.fromUrl(url, params.addLineNumbers);
        }
        catch (RiskscapeIOException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)ex, (String)"Failed to open csv data from %s", (Object[])new Object[]{url})});
        }
        if (params.geometryAttribute.isPresent()) {
            TypeProjection projection = this.buildProjection(fromUrl, params);
            return fromUrl.project((Projection)projection);
        }
        return ResultOrProblems.of((Object)((Object)fromUrl));
    }

    private TypeProjection buildProjection(CsvRelation fromUrl, CsvParams params) {
        String geometryAttribute = params.geometryAttribute.orElse(null);
        Expression geometryExpression = params.geometryExpression.orElse(null);
        CoordinateReferenceSystem crs = params.crs.orElse(null);
        Struct rawType = fromUrl.getType();
        Struct newType = rawType.hasMember(geometryAttribute) ? rawType.replace(geometryAttribute, (Type)Types.GEOMETRY) : rawType.add(geometryAttribute, (Type)Types.GEOMETRY);
        ImmutableMap attrMap = geometryExpression != null ? ImmutableMap.of((Object)geometryAttribute, (Object)geometryExpression) : ImmutableMap.of();
        final SpatialMetadata spatialMetadata = new SpatialMetadata(crs, TupleUtils.findRequiredGeometryMember((Struct)newType));
        TypeProjection projection = new TypeProjection(newType, (Map)attrMap, params.getRealizationContext()){

            public ResultOrProblems<Projector> getProjectionFunction(Struct sourceType) {
                return this.buildMemberList(sourceType).map(mapping -> new TypeProjection.TypeProjector(sourceType, mapping.targetType, mapping.memberList){

                    public Optional<Function<SpatialMetadata, SpatialMetadata>> getSpatialMetadataMapper() {
                        return Optional.of(ignored -> spatialMetadata);
                    }
                });
            }
        };
        return projection;
    }

    protected Map<String, String> getExtensionsToFormats() {
        return EXTENSIONS_TO_FORMATS;
    }

    protected void validateParameters(CsvParams params, BindingContext context) {
        super.validateParameters((RelationBookmarkParams)params, null);
        if (params.geometryExpression.isPresent() && !params.geometryAttribute.isPresent()) {
            params.geometryAttribute = Optional.ofNullable(DEFAULT_GEOMETRY_ATTRIBUTE);
        }
        if (params.geometryAttribute.isPresent() && !params.crs.isPresent()) {
            params.crs = Optional.of(params.getProject().getDefaultCrs());
            params.add(((ParamProblems)Problems.get(ParamProblems.class)).applyingDefault("crs-name", (Object)params.getProject().getDefaultCrs()).withSeverity(Problem.Severity.WARNING));
        }
    }

    public static class CsvParams
    extends RelationBookmarkParams {
        @ParameterField
        public Optional<String> geometryAttribute = Optional.empty();
        @ParameterField
        public Optional<Expression> geometryExpression = Optional.empty();
        @ParameterField
        public boolean addLineNumbers = false;
    }
}

