/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.defaults;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import lombok.Generated;
import nz.org.riskscape.config.BootstrapIniSettings;
import nz.org.riskscape.config.ConfigUtils;
import nz.org.riskscape.defaults.auth.KoordinatesKeySecret;
import nz.org.riskscape.defaults.auth.PlatformSecret;
import nz.org.riskscape.defaults.classifier.ClassifierFunction;
import nz.org.riskscape.defaults.classifier.ClassifierFunctionFramework;
import nz.org.riskscape.defaults.curves.ContinuousLinearFitter;
import nz.org.riskscape.defaults.curves.CurveFitter;
import nz.org.riskscape.defaults.curves.FitCurveFunction;
import nz.org.riskscape.defaults.curves.LinearFitter;
import nz.org.riskscape.defaults.curves.PowerLawFitter;
import nz.org.riskscape.defaults.curves.TrapezoidIntegrationFunction;
import nz.org.riskscape.defaults.function.AALHazardBasedFunction;
import nz.org.riskscape.defaults.function.BucketFunction;
import nz.org.riskscape.defaults.function.BucketRange;
import nz.org.riskscape.defaults.function.CombineCoverages;
import nz.org.riskscape.defaults.function.ListToColumns;
import nz.org.riskscape.defaults.function.LookupFunction;
import nz.org.riskscape.defaults.function.MapCoverage;
import nz.org.riskscape.defaults.function.Segment;
import nz.org.riskscape.defaults.function.SegmentByGrid;
import nz.org.riskscape.defaults.function.ToListFunction;
import nz.org.riskscape.defaults.function.ToLookupTable;
import nz.org.riskscape.defaults.interp.ApplyContinuousFunction;
import nz.org.riskscape.defaults.interp.CreateContinuousFunction;
import nz.org.riskscape.defaults.interp.StackContinuousFunction;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.auth.SecretBuilders;
import nz.org.riskscape.engine.bind.DefaultBindingContext;
import nz.org.riskscape.engine.data.BookmarkResolvers;
import nz.org.riskscape.engine.data.coverage.CoverageFileBookmarkResolver;
import nz.org.riskscape.engine.defaults.data.CsvResolver;
import nz.org.riskscape.engine.defaults.data.DataURILoader;
import nz.org.riskscape.engine.defaults.data.GeoJSONResolver;
import nz.org.riskscape.engine.defaults.data.GeoPackageRelationResolver;
import nz.org.riskscape.engine.defaults.data.KmlResolver;
import nz.org.riskscape.engine.defaults.data.ShapefileBookmarkResolver;
import nz.org.riskscape.engine.defaults.data.WfsBookmarkResolver;
import nz.org.riskscape.engine.defaults.data.jdbc.GeoPackageFormat;
import nz.org.riskscape.engine.defaults.function.IsExposed;
import nz.org.riskscape.engine.defaults.function.LookupBookmark;
import nz.org.riskscape.engine.defaults.resource.HttpResourceLoader;
import nz.org.riskscape.engine.defaults.resource.SwiftObjectStorageResourceLoader;
import nz.org.riskscape.engine.function.ApplyFunction;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionClassLoader;
import nz.org.riskscape.engine.function.FunctionContext;
import nz.org.riskscape.engine.function.FunctionProvider;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.JavaFunction;
import nz.org.riskscape.engine.function.OperatorResolver;
import nz.org.riskscape.engine.function.StringFunctions;
import nz.org.riskscape.engine.function.geometry.LayerIntersections;
import nz.org.riskscape.engine.function.geometry.SampleCoverage;
import nz.org.riskscape.engine.function.geometry.SampleCoverageAtCentroid;
import nz.org.riskscape.engine.function.geometry.SampleCoverageOne;
import nz.org.riskscape.engine.function.geometry.ToTypedCoverage;
import nz.org.riskscape.engine.function.lang.Call;
import nz.org.riskscape.engine.function.lang.MergeStruct;
import nz.org.riskscape.engine.output.CsvFormat;
import nz.org.riskscape.engine.output.FileSystemPipelineOutputStore;
import nz.org.riskscape.engine.output.GeoJSONFormat;
import nz.org.riskscape.engine.output.GeoPackagePipelineOutputStore;
import nz.org.riskscape.engine.output.KmlFormat;
import nz.org.riskscape.engine.output.QGSWriter;
import nz.org.riskscape.engine.output.ShapefileFormat;
import nz.org.riskscape.engine.output.ShapefileGeotoolsFormat;
import nz.org.riskscape.engine.pipeline.ParameterizedPipelineModelFramework;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginFeature;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoader;
import nz.org.riskscape.engine.rl.DefaultOperators;
import nz.org.riskscape.engine.rl.GeometryFunctions;
import nz.org.riskscape.engine.rl.LanguageFunctions;
import nz.org.riskscape.engine.rl.LogicFunctions;
import nz.org.riskscape.engine.rl.MathsFunctions;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.spi.EngineBootstrapper;
import nz.org.riskscape.engine.steps.EnlargeStep;
import nz.org.riskscape.engine.steps.FilterStep;
import nz.org.riskscape.engine.steps.GroupByStep;
import nz.org.riskscape.engine.steps.JoinStep;
import nz.org.riskscape.engine.steps.RelationInputStep;
import nz.org.riskscape.engine.steps.SaveStep;
import nz.org.riskscape.engine.steps.SelectStep;
import nz.org.riskscape.engine.steps.SortStep;
import nz.org.riskscape.engine.steps.UnionStep;
import nz.org.riskscape.engine.steps.UnnestStep;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeRegistry;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugin
extends nz.org.riskscape.engine.plugin.Plugin
implements FunctionProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Plugin.class);
    private boolean useV2ClassifierFormat = true;
    private boolean outputQgisProject = true;
    public static final String FUNCTION_CLASSES_ATTRIBUTE_NAME = "Riskscape-Function-Classes";
    private static final String CLASSIFIER_FUNCTIONS_USE_NEW_FORMAT = "classifier-functions.v2-enabled";
    private static final String OUTPUT_QGIS_PROJECT = "output.qgis-project";
    public static final URI DEFAULTS_SOURCE_URI = URI.create("riskscape:default-plugin");
    public static final Resource DEFAULTS_SOURCE = new Resource.PseudoResource(DEFAULTS_SOURCE_URI);

    public static void addDefaultTypeInformation(Engine engine) {
        TypeRegistry.addDefaults((TypeRegistry)engine.getTypeRegistry());
    }

    public Plugin(PluginDescriptor pDescriptor) {
        super(pDescriptor);
    }

    public List<Problem> initializeEngine(Engine engine) {
        BookmarkResolvers resolvers = engine.getBookmarkResolvers();
        resolvers.add((Identified)new ShapefileBookmarkResolver(engine));
        resolvers.add((Identified)new CoverageFileBookmarkResolver(engine));
        resolvers.add((Identified)new WfsBookmarkResolver(engine));
        resolvers.add((Identified)new CsvResolver(engine));
        resolvers.add((Identified)new GeoJSONResolver(engine));
        resolvers.add((Identified)new KmlResolver(engine));
        resolvers.add((Identified)new GeoPackageRelationResolver(engine));
        engine.getModelFrameworks().add((Identified)new ParameterizedPipelineModelFramework(engine));
        engine.getBinders().addAll((Collection)DefaultBindingContext.DEFAULT_BINDERS);
        engine.getFunctionFrameworks().add((Identified)new ClassifierFunctionFramework());
        this.addOutputFormats(engine);
        Plugin.addDefaultTypeInformation(engine);
        engine.getResourceFactory().add((ResourceLoader)new DataURILoader(engine));
        engine.getPipelineOutputStores().add((Identified)new FileSystemPipelineOutputStore());
        engine.getPipelineOutputStores().add((Identified)new GeoPackagePipelineOutputStore());
        if (this.outputQgisProject) {
            engine.getPipelineOutputStores().getAll().stream().filter(store -> store instanceof FileSystemPipelineOutputStore).map(store -> (FileSystemPipelineOutputStore)store).findFirst().ifPresent(store -> store.onCompletion(QGSWriter.WRITE_PROJECT_FILE));
        }
        ((SecretBuilders)engine.getCollection(SecretBuilders.class)).add((Identified)PlatformSecret.BUILDER);
        ((SecretBuilders)engine.getCollection(SecretBuilders.class)).add((Identified)KoordinatesKeySecret.BUILDER);
        return Collections.emptyList();
    }

    public void startUp(Map<String, List<String>> settingsConfig, ProblemSink sink) {
        super.startUp(settingsConfig);
        BootstrapIniSettings settings = new BootstrapIniSettings(settingsConfig, sink);
        this.useV2ClassifierFormat = settings.getOrDefault(CLASSIFIER_FUNCTIONS_USE_NEW_FORMAT, true);
        this.outputQgisProject = settings.getOrDefault(OUTPUT_QGIS_PROJECT, true);
        if (!this.useV2ClassifierFormat) {
            log.warn("Support for v1 classifier functions has been removed, ignoring setting {}", (Object)CLASSIFIER_FUNCTIONS_USE_NEW_FORMAT);
        }
    }

    public List<Problem> initializeProject(Project project, Engine engine) {
        project.add(new IsExposed().asFunction().builtin("is_exposed", IdentifiedFunction.Category.RISK_MODELLING));
        return Collections.emptyList();
    }

    public void addFunctions(Project project, Consumer<Problem> problemSink) {
        this.addFunctionsFromConfig(project).forEach(problemSink);
        project.getFunctionSet().insertFirst((OperatorResolver)DefaultOperators.INSTANCE);
        GeometryFunctions geometryFunctions = new GeometryFunctions(project.getEngine());
        project.getFunctionSet().addAll((Collection)geometryFunctions.getPredicates(), DEFAULTS_SOURCE);
        project.getFunctionSet().addAll((Collection)geometryFunctions.getFunctions(), DEFAULTS_SOURCE);
        project.getFunctionSet().addAll((Collection)LogicFunctions.LOGIC_FUNCTIONS, DEFAULTS_SOURCE);
        project.getFunctionSet().addAll((Collection)MathsFunctions.FUNCTIONS, DEFAULTS_SOURCE);
        project.getFunctionSet().addAll((Collection)StringFunctions.FUNCTIONS, DEFAULTS_SOURCE);
        project.getFunctionSet().addAll((Collection)LanguageFunctions.FUNCTIONS, DEFAULTS_SOURCE);
        LookupBookmark lookupBookmark = new LookupBookmark();
        project.getFunctionSet().add((Identified)RealizableFunction.asFunction((RealizableFunction)lookupBookmark, (ArgumentList)lookupBookmark.getArguments(), (Type)Types.ANYTHING).builtin("bookmark", IdentifiedFunction.Category.MISC), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new ToTypedCoverage().builtin("relation_to_coverage", IdentifiedFunction.Category.MISC), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new MergeStruct().builtin("merge", IdentifiedFunction.Category.LANGUAGE), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new Call().builtin("call", IdentifiedFunction.Category.LANGUAGE), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new SampleCoverage().builtin("sample", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new SampleCoverageAtCentroid().builtin("sample_centroid", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new SampleCoverageOne().builtin("sample_one", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new Segment().builtin("segment", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new SegmentByGrid().builtin("segment_by_grid", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new LayerIntersections().builtin("layer_intersection", IdentifiedFunction.Category.GEOMETRY_PROCESSING), DEFAULTS_SOURCE);
        project.getFunctionSet().add((Identified)new CombineCoverages().builtin("combine_coverages", IdentifiedFunction.Category.GEOMETRY_PROCESSING));
        project.getFunctionSet().add((Identified)new MapCoverage().builtin("map_coverage", IdentifiedFunction.Category.GEOMETRY_PROCESSING));
        project.getFunctionSet().add((Identified)new ToListFunction().builtin("to_list", IdentifiedFunction.Category.LANGUAGE));
        project.getFunctionSet().add((Identified)new LookupFunction().builtin("lookup", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().add((Identified)new ListToColumns().builtin("list_to_columns", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().add((Identified)new ToLookupTable().asRiskscapeFunction().builtin("to_lookup_table", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().add((Identified)AggregationFunction.asFunction((AggregationFunction)new BucketFunction()).builtin("bucket", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().add((Identified)AggregationFunction.asFunction((AggregationFunction)new BucketRange(new BucketFunction())).builtin("bucket_range", IdentifiedFunction.Category.MISC));
        project.getFunctionSet().addAll(Arrays.asList(new CreateContinuousFunction().asFunction().builtin("create_continuous", IdentifiedFunction.Category.MATHS), new ApplyContinuousFunction().asFunction().builtin("apply_continuous", IdentifiedFunction.Category.MATHS), AggregationFunction.asFunction((AggregationFunction)new StackContinuousFunction()).builtin("stack_continuous", IdentifiedFunction.Category.MATHS)));
        project.getFunctionSet().add((Identified)new ApplyFunction().asFunction().builtin("apply", IdentifiedFunction.Category.MATHS));
        List<CurveFitter<?>> fitters = Arrays.asList(new LinearFitter(), new PowerLawFitter(), new ContinuousLinearFitter());
        project.getFunctionSet().add((Identified)AggregationFunction.asFunction((AggregationFunction)new FitCurveFunction(fitters)).builtin("fit_curve", IdentifiedFunction.Category.MATHS));
        project.getFunctionSet().add((Identified)new TrapezoidIntegrationFunction().builtin("trapz", IdentifiedFunction.Category.MATHS));
        project.getFunctionSet().add((Identified)new AALHazardBasedFunction().builtin("aal_trapz", IdentifiedFunction.Category.MATHS));
    }

    private Collection<? extends Problem> addFunctionsFromConfig(Project project) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!this.useV2ClassifierFormat) {
            problems.add(new Problem(Problem.Severity.INFO, String.format("v2 classifier functions are disabled.  Add `v2-enabled = true` to your settings.ini under the [classifier-functions] section to enable v2", new Object[0])));
        }
        ConfigUtils.getResources((Project)project, p -> problems.add((Problem)p), cs -> cs.getName().startsWith("project"), (String)"functions").forEach(resource -> {
            if (resource.getLocation().getPath().endsWith(".txt")) {
                log.debug("Attempting to build function from {}", resource);
                this.addTextFunction((List<Problem>)problems, project, (Resource)resource);
            } else if (resource.getLocation().getPath().endsWith(".jar")) {
                this.loadFunctionsFromJar((Resource)resource, project, (List<Problem>)problems);
            }
        });
        return problems;
    }

    private void addTextFunction(List<Problem> problems, Project project, Resource resource) {
        String source = resource.getContentAsString();
        ResultOrProblems functionOr = ClassifierFunction.build(project, source).flatMap(f -> f.identified(resource));
        if (functionOr.isPresent()) {
            project.getFunctionSet().add(((IdentifiedFunction)functionOr.get()).getId(), resource, () -> functionOr);
        } else {
            problems.addAll(functionOr.composeFailure(Problems.foundWith(ClassifierFunction.class, (String)resource.getLocation().toString(), (Problem[])new Problem[0])).getProblems());
        }
    }

    public void addOutputFormats(Engine engine) {
        engine.getFormats().add((Identified)new CsvFormat());
        engine.getFormats().add((Identified)new ShapefileFormat());
        engine.getFormats().add((Identified)new ShapefileGeotoolsFormat());
        engine.getFormats().add((Identified)new GeoJSONFormat());
        engine.getFormats().add((Identified)new KmlFormat());
        engine.getFormats().add((Identified)new GeoPackageFormat());
    }

    void loadFunctionsFromJar(Resource jarFunctionResource, Project project, List<Problem> problems) {
        FunctionContext context = new FunctionContext(project.getTypeSet());
        try {
            ResultOrProblems localPath = jarFunctionResource.ensureLocal(Resource.SECURE_OPTIONS);
            problems.addAll(localPath.getProblems());
            if (!localPath.isPresent()) {
                return;
            }
            URL jarURL = ((Path)localPath.get()).toUri().toURL();
            FunctionClassLoader functionLoader = new FunctionClassLoader(new URL[]{jarURL}, Engine.class.getClassLoader());
            URL manifestUrl = functionLoader.findResource("META-INF/MANIFEST.MF");
            if (manifestUrl == null) {
                functionLoader.close();
                problems.add(Problem.error((String)"Could not find required META-INF/MANIFEST.MF in %s", (Object[])new Object[]{jarFunctionResource.getLocation()}));
            } else {
                Manifest manifest = new Manifest(manifestUrl.openStream());
                String functionClasses = manifest.getMainAttributes().getValue(FUNCTION_CLASSES_ATTRIBUTE_NAME);
                Class loadedClass = null;
                ArrayList jarProblems = Lists.newArrayList();
                for (String functionClassName : functionClasses.split("\\s")) {
                    try {
                        loadedClass = functionLoader.loadClass(functionClassName);
                        if (!IdentifiedFunction.class.isAssignableFrom(loadedClass)) {
                            jarProblems.add(Problem.error((String)"Function class %s must extend %s", (Object[])new Object[]{functionClassName, IdentifiedFunction.class}));
                            continue;
                        }
                        Class functionClass = loadedClass;
                        Constructor constructor = functionClass.getConstructor(FunctionContext.class);
                        IdentifiedFunction function = (IdentifiedFunction)constructor.newInstance(context);
                        if (function instanceof JavaFunction) {
                            ((JavaFunction)function).setSourceURI(jarFunctionResource.getLocation());
                        }
                        project.getFunctionSet().add((Identified)function, jarFunctionResource);
                    }
                    catch (NoSuchMethodException e) {
                        jarProblems.add(Problem.error((Throwable)e, (String)"Function class %s does not define %s(%s)", (Object[])new Object[]{functionClassName, loadedClass.getSimpleName(), FunctionContext.class}));
                    }
                    catch (ClassNotFoundException e) {
                        jarProblems.add(Problem.error((Throwable)e, (String)"Function class %s does not exist", (Object[])new Object[]{functionClassName}));
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        jarProblems.add(Problem.error((Throwable)e, (String)"Function class %s could not be instantiated. Cause: %s", (Object[])new Object[]{functionClassName, e.getMessage()}));
                    }
                }
                if (!jarProblems.isEmpty()) {
                    problems.add(Problem.composite((List)jarProblems, (String)"Problems found in function jar %s", (Object[])new Object[]{jarFunctionResource.getLocation()}));
                }
            }
        }
        catch (MalformedURLException e) {
            problems.add(Problem.error((Throwable)e, (String)"Could not find a jar file at %s", (Object[])new Object[]{jarFunctionResource.getLocation()}));
        }
        catch (IOException e) {
            problems.add(Problem.error((Throwable)e, (String)"Could not read manifest file from %s", (Object[])new Object[]{jarFunctionResource.getLocation()}));
        }
    }

    public void addSteps(Engine engine) {
        engine.getPipelineSteps().addAll(Arrays.asList(new RelationInputStep(engine), new FilterStep(engine), new JoinStep(engine), new UnnestStep(engine), new SelectStep(engine), new SortStep(engine), new GroupByStep(engine), new SaveStep(engine), new EnlargeStep(engine), new UnionStep(engine)));
    }

    public void addResourceLoaders(Engine engine) {
        engine.getResourceFactory().add((ResourceLoader)new HttpResourceLoader(engine));
        engine.getResourceFactory().add((ResourceLoader)new SwiftObjectStorageResourceLoader());
    }

    public List<PluginFeature> getFeatures() {
        return Arrays.asList(new EngineBootstrapper("default-pipeline-steps", this::addSteps), new EngineBootstrapper("default-resource-loaders", this::addResourceLoaders));
    }
}

