/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Nullable;
import nz.org.riskscape.defaults.interp.ContinuousFunctionType;
import nz.org.riskscape.defaults.interp.StackableContinuousFunction;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

abstract class StackableContinuousFunctionType<F extends StackableContinuousFunction>
extends ContinuousFunctionType {
    private final boolean compress;
    private final int numCompressedMembers;
    private final Struct uncompressedType;

    StackableContinuousFunctionType(int dimensions, RealizedExpression valueExpression, Type returnType, boolean compress) {
        super(dimensions, valueExpression, returnType);
        this.compress = compress;
        this.uncompressedType = returnType.find(Struct.class).orElse(null);
        if (this.uncompressedType == null) {
            this.numCompressedMembers = returnType.equals(Types.FLOATING) ? 1 : 0;
        } else if (compress) {
            for (Struct.StructMember member : this.uncompressedType.getMembers()) {
                if (member.getType() == Types.FLOATING) continue;
                throw new IllegalArgumentException("Result type not suitable for compression: " + String.valueOf(returnType));
            }
            this.numCompressedMembers = this.uncompressedType.size();
        } else {
            this.numCompressedMembers = 0;
        }
        if (compress && this.numCompressedMembers == 0) {
            throw new IllegalArgumentException("Result type not suitable for compression: " + String.valueOf(returnType));
        }
    }

    abstract Object getOrComputeValue(F var1, int var2);

    void populate(F function) {
        for (int i = this.getSize() - 1; i >= 0; --i) {
            this.getOrComputeValue(function, i);
        }
        ((StackableContinuousFunction)function).lambda = null;
    }

    abstract F newFunction(@Nullable ScopedLambdaExpression var1);

    F newAccumulator() {
        return this.newFunction(null);
    }

    public Object newArray() {
        int size = this.getSize();
        if (this.compress) {
            float[] floats = new float[size * this.numCompressedMembers];
            Arrays.fill(floats, Float.NaN);
            return floats;
        }
        return new Object[size];
    }

    public void setValue(F function, int arrayIndex, Object value) {
        if (this.compress) {
            float[] floats = (float[])((StackableContinuousFunction)function).values;
            if (this.uncompressedType != null) {
                Tuple tuple = (Tuple)value;
                int offset = arrayIndex * this.numCompressedMembers;
                for (int memberIndex = 0; memberIndex < this.numCompressedMembers; ++memberIndex) {
                    Number number = (Number)tuple.fetch(memberIndex);
                    floats[offset + memberIndex] = number.floatValue();
                }
            } else {
                floats[arrayIndex] = ((Double)value).floatValue();
            }
        } else {
            ((Object[])((StackableContinuousFunction)function).values)[arrayIndex] = value;
        }
    }

    public Object getValue(F function, int index) {
        if (this.compress) {
            float[] floats = (float[])((StackableContinuousFunction)function).values;
            if (this.uncompressedType != null) {
                Tuple tuple = Tuple.of((Struct)this.uncompressedType);
                int offset = index * this.numCompressedMembers;
                if (Float.isNaN(floats[offset])) {
                    return null;
                }
                for (Struct.StructMember member : this.uncompressedType.getMembers()) {
                    float f = floats[offset++];
                    tuple.set(member, (Object)f);
                }
                return tuple;
            }
            float value = floats[index];
            if (Float.isNaN(value)) {
                return null;
            }
            return (double)value;
        }
        return ((Object[])((StackableContinuousFunction)function).values)[index];
    }

    public abstract int getSize();

    public void copyValues(F srcFunction, F destFunction) {
        System.arraycopy(((StackableContinuousFunction)srcFunction).values, 0, ((StackableContinuousFunction)destFunction).values, 0, Array.getLength(((StackableContinuousFunction)destFunction).values));
    }
}

