/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import com.google.common.collect.Lists;
import java.util.List;
import nz.org.riskscape.defaults.interp.BilinearContinuousFunctionType;
import nz.org.riskscape.defaults.interp.ContinuousFunctionType;
import nz.org.riskscape.defaults.interp.LinearContinuousFunctionType;
import nz.org.riskscape.defaults.interp.StackableContinuousFunction;
import nz.org.riskscape.defaults.interp.StackableContinuousFunctionType;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class StackContinuousFunction
implements AggregationFunction {
    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return ProblemException.catching(() -> {
            if (fc.getPositionalArguments().size() != 1) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(1, fc.getPositionalArguments().size()));
            }
            RealizedExpression functionExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(0)).getExpression()).getOrThrow();
            ContinuousFunctionType type = (ContinuousFunctionType)Types.findOrThrow((Object)"value", (Type)ContinuousFunctionType.ANY, (Type)functionExpression.getResultType());
            if (type instanceof StackableContinuousFunctionType) {
                StackableContinuousFunctionType stackableFunctionType = (StackableContinuousFunctionType)type;
                type.getValueType().findAllowNull(Struct.class).ifPresent(struct -> context.normalizeStruct(struct));
                Struct combineValuesInput = context.normalizeStruct(Struct.of((String)"a", (Type)type.getValueType(), (String)"b", (Type)type.getValueType()));
                RealizedExpression combineYValuesExpression = (RealizedExpression)context.getExpressionRealizer().realize((Type)combineValuesInput, ExpressionParser.parseString((String)"a + b")).getOrThrow();
                return RealizedAggregateExpression.create((Type)inputType, (Type)functionExpression.getResultType(), (Expression)fc, () -> new AccumulatorImpl(stackableFunctionType, functionExpression, combineYValuesExpression));
            }
            throw new ProblemException((Problems)TypeProblems.get().requiresOneOf((Object)"value", (List)Lists.newArrayList((Object[])new Type[]{LinearContinuousFunctionType.ANY, BilinearContinuousFunctionType.ANY_BILINEAR}), (Type)type));
        });
    }

    private static final class AccumulatorImpl
    implements Accumulator {
        private final StackableContinuousFunction accumulator;
        private final StackableContinuousFunctionType functionType;
        private final RealizedExpression functionExpression;
        private final RealizedExpression combineValuesExpression;
        private boolean empty = true;
        private final Tuple combineValuesInput;

        AccumulatorImpl(StackableContinuousFunctionType<?> functionType, RealizedExpression functionExpression, RealizedExpression combineYValuesExpression) {
            this.functionType = functionType;
            this.functionExpression = functionExpression;
            this.combineValuesExpression = combineYValuesExpression;
            this.accumulator = functionType.newAccumulator();
            this.combineValuesInput = new Tuple((Struct)combineYValuesExpression.getInputType());
        }

        public Accumulator combine(Accumulator rhs) {
            AccumulatorImpl impl = (AccumulatorImpl)rhs;
            if (this.empty) {
                return impl;
            }
            if (!impl.empty) {
                StackableContinuousFunction function = impl.accumulator;
                int len = this.functionType.getSize();
                for (int i = 0; i < len; ++i) {
                    this.combineValuesInput.set(0, this.functionType.getValue(this.accumulator, i));
                    this.combineValuesInput.set(1, this.functionType.getValue(function, i));
                    this.functionType.setValue(this.accumulator, i, this.combineValuesExpression.evaluate((Object)this.combineValuesInput));
                }
            }
            return this;
        }

        public void accumulate(Object input) {
            StackableContinuousFunction function = (StackableContinuousFunction)this.functionExpression.evaluate(input);
            this.functionType.populate(function);
            if (this.empty) {
                this.empty = false;
                this.functionType.copyValues(function, this.accumulator);
            } else {
                int len = this.functionType.getSize();
                for (int i = 0; i < len; ++i) {
                    this.combineValuesInput.set(0, this.functionType.getValue(this.accumulator, i));
                    this.combineValuesInput.set(1, this.functionType.getValue(function, i));
                    this.functionType.setValue(this.accumulator, i, this.combineValuesExpression.evaluate((Object)this.combineValuesInput));
                }
            }
        }

        public Object process() {
            return this.accumulator;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

