/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.defaults.interp.LinearContinuousFunction;
import nz.org.riskscape.defaults.interp.StackableContinuousFunctionType;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;

final class LinearContinuousFunctionType
extends StackableContinuousFunctionType<LinearContinuousFunction> {
    public static final LinearContinuousFunctionType ANY = new LinearContinuousFunctionType();
    public static final Object VISITOR_META_CVALUE = "cvalue";
    public static final Object VISITOR_META_MVALUE = "mvalue";
    public static final Object VISITOR_META_YVALUE = "yvalue";
    private final double[] xValues;
    private final Struct slopeInputType;
    private final RealizedExpression slopeExpression;
    private final Struct yInterceptInputType;
    private final RealizedExpression yInterceptExpression;
    private final Struct solveForYExpressionInputType;
    private final RealizedExpression solveForYExpression;

    LinearContinuousFunctionType(double[] xValues, RealizedExpression yExpression, Struct slopeInputType, RealizedExpression slopeExpression, Struct yInterceptInputType, RealizedExpression yInterceptExpression, Struct solveForYExpressionInputType, RealizedExpression solveForYExpression) {
        super(1, yExpression, solveForYExpression.getResultType(), false);
        this.xValues = xValues;
        this.slopeInputType = slopeInputType;
        this.slopeExpression = slopeExpression;
        this.yInterceptInputType = yInterceptInputType;
        this.yInterceptExpression = yInterceptExpression;
        this.solveForYExpressionInputType = solveForYExpressionInputType;
        this.solveForYExpression = solveForYExpression;
    }

    private LinearContinuousFunctionType() {
        super(1, null, (Type)Types.ANYTHING, false);
        this.xValues = new double[0];
        this.slopeExpression = null;
        this.slopeInputType = null;
        this.solveForYExpression = null;
        this.solveForYExpressionInputType = null;
        this.yInterceptExpression = null;
        this.yInterceptInputType = null;
    }

    @Override
    public String toString() {
        return String.format("ContinuousCurve(xvalues=%s, returnType=%s)", Doubles.asList((double[])this.xValues), this.returnType);
    }

    public Type getCValueType() {
        return this.yInterceptExpression.getResultType();
    }

    public Type getMValueType() {
        return this.slopeExpression.getResultType();
    }

    @Override
    public Object applyTo(Object func, double ... dimensionValues) {
        LinearContinuousFunction function = (LinearContinuousFunction)func;
        double xValue = dimensionValues[0];
        int size = this.xValues.length;
        if (xValue < this.xValues[0]) {
            return this.solveForY(function, this.xValues[0], 0);
        }
        if (xValue >= this.xValues[size - 1]) {
            return this.solveForY(function, this.xValues[size - 1], size - 2);
        }
        for (int i = 0; i < size - 1; ++i) {
            double x0 = this.xValues[i];
            double x1 = this.xValues[i + 1];
            if (!(xValue >= x0) || !(xValue < x1)) continue;
            return this.solveForY(function, xValue, i);
        }
        throw new AssertionError((Object)"should not be possible");
    }

    private Object solveForY(LinearContinuousFunction function, double xValue, int index) {
        Object slope = this.getOrComputeSlope(function, index);
        Object yIntercept = this.getOrComputeYIntercept(function, index);
        return this.solveForY(slope, yIntercept, xValue);
    }

    private Object solveForY(Object slope, Object yIntercept, double xValue) {
        Tuple inputType = Tuple.ofValues((Struct)this.solveForYExpressionInputType, (Object[])new Object[]{slope, xValue, yIntercept});
        return this.solveForYExpression.evaluate((Object)inputType);
    }

    private Object getOrComputeYIntercept(LinearContinuousFunction function, int i) {
        if (function.cValues[i] == null) {
            Object m = function.mValues[i];
            Object y1 = this.getValue(function, i);
            double x1 = this.xValues[i];
            Tuple tuple = Tuple.ofValues((Struct)this.yInterceptInputType, (Object[])new Object[]{y1, m, x1});
            function.cValues[i] = this.yInterceptExpression.evaluate((Object)tuple);
        }
        return function.cValues[i];
    }

    private Object getOrComputeSlope(LinearContinuousFunction function, int i) {
        Object mValue = function.mValues[i];
        if (mValue == null) {
            Object y0 = this.getOrComputeValue(function, i);
            Object y1 = this.getOrComputeValue(function, i + 1);
            double x0 = this.xValues[i];
            double x1 = this.xValues[i + 1];
            Tuple tuple = Tuple.ofValues((Struct)this.slopeInputType, (Object[])new Object[]{x0, x1, y0, y1});
            function.mValues[i] = mValue = this.slopeExpression.evaluate((Object)tuple);
        }
        return mValue;
    }

    @Override
    protected Object getOrComputeValue(LinearContinuousFunction function, int i) {
        Object currentValue = this.getValue(function, i);
        if (currentValue == null) {
            Tuple inputTuple = function.lambda.buildCallingScope((Struct)this.valueExpression.getInputType(), new Object[]{this.xValues[i]});
            inputTuple.set(inputTuple.size() - 1, (Object)this.xValues[i]);
            currentValue = this.valueExpression.evaluate((Object)inputTuple);
            this.setValue(function, i, currentValue);
        }
        return currentValue;
    }

    @Override
    LinearContinuousFunction newFunction(ScopedLambdaExpression lambda) {
        return new LinearContinuousFunction(lambda, this);
    }

    @Override
    public int getSize() {
        return this.xValues.length;
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        List<Pair> children = Arrays.asList(Pair.of((Object)this.getCValueType(), (Object)VISITOR_META_CVALUE), Pair.of((Object)this.getMValueType(), (Object)VISITOR_META_MVALUE), Pair.of((Object)this.getValueType(), (Object)VISITOR_META_YVALUE));
        return (U)tv.compoundType((Type)this, children, data);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinearContinuousFunctionType)) {
            return false;
        }
        LinearContinuousFunctionType other = (LinearContinuousFunctionType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getXValues(), other.getXValues());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LinearContinuousFunctionType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getXValues());
        return result;
    }

    @Generated
    public double[] getXValues() {
        return this.xValues;
    }

    public static class Builder {
        public final RealizationContext context;
        public RealizedExpression yExpression;
        public double[] xValues;
        public Type xType;
        public boolean logScale = false;

        public ResultOrProblems<LinearContinuousFunctionType> build(Consumer<Builder> setupVisitor) {
            setupVisitor.accept(this);
            return ProblemException.catching(() -> {
                Type yType = this.yExpression.getResultType();
                String slopeExprString = this.logScale ? "(y1 - y0) / (log(x1) - log(x0))" : "(y1 - y0) / (x1 - x0)";
                String yInterceptExprString = this.logScale ? "y1 - (m * log(x1))" : "y1 - (m * x1)";
                String solveForYExprString = this.logScale ? "(m * log(x)) + c" : "(m * x) + c";
                Struct slopeInputType = Struct.of((String)"x0", (Type)this.xType, (String)"x1", (Type)this.xType, (String)"y0", (Type)yType, (String)"y1", (Type)yType);
                RealizedExpression slopeExpression = this.realize(slopeInputType, slopeExprString);
                Struct yInterceptInputType = Struct.of((String)"y1", (Type)yType, (String)"m", (Type)slopeExpression.getResultType(), (String)"x1", (Type)Types.FLOATING);
                RealizedExpression yInterceptExpression = this.realize(yInterceptInputType, yInterceptExprString);
                Struct solveForYExpressionInputType = Struct.of((String)"m", (Type)slopeExpression.getResultType(), (String)"x", (Type)Types.FLOATING, (String)"c", (Type)yInterceptExpression.getResultType());
                RealizedExpression solveForYExpression = this.realize(solveForYExpressionInputType, solveForYExprString);
                return new LinearContinuousFunctionType(this.xValues, this.yExpression, slopeInputType, slopeExpression, yInterceptInputType, yInterceptExpression, solveForYExpressionInputType, solveForYExpression);
            });
        }

        public RealizedExpression realize(Struct inputType, String expr) throws ProblemException {
            Expression parsed = ExpressionParser.parseString((String)expr);
            return (RealizedExpression)this.context.getExpressionRealizer().realize((Type)inputType, parsed).getOrThrow();
        }

        @Generated
        public Builder(RealizationContext context) {
            this.context = context;
        }
    }
}

