/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import com.google.common.primitives.Doubles;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.defaults.interp.LinearContinuousFunctionType;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class CreateContinuousFunction
implements RealizableFunction {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final ArgumentList arguments = ArgumentList.create((String)"x-values", (Type)RSList.create((Type)Types.ANYTHING), (String)"apply-to", (Type)new LambdaType(new String[]{"x-value"}), (String)"apply-log-to-x", (Type)Types.BOOLEAN);

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            if (argumentTypes.size() > this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(this.arguments.size(), argumentTypes.size()));
            }
            if (argumentTypes.size() < 2) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, argumentTypes.size()));
            }
            RSList listType = (RSList)Types.findOrThrow((Object)"x-values", (Type)RSList.create((Type)Types.ANYTHING), (Type)((Type)argumentTypes.get(0)));
            FunctionCall.Argument xValuesArg = (FunctionCall.Argument)this.arguments.getRequiredArgument(functionCall, "x-values").getOrThrow();
            List xValues = (List)xValuesArg.evaluateConstant(context, List.class, (Type)RSList.create((Type)Types.ANYTHING)).getOrThrow();
            if (!Number.class.isAssignableFrom(listType.getContainedType().internalType())) {
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)"x-values", Number.class, listType.getContainedType().internalType()));
            }
            ScopedLambdaType type = (ScopedLambdaType)Types.findOrThrow((Object)"apply-to", (Type)new ScopedLambdaType(Struct.EMPTY_STRUCT, new String[]{"x"}), (Type)((Type)argumentTypes.get(1)));
            if (type.getArgs().size() != 1) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get("apply-to"), (Type)type));
            }
            Struct lambdaScope = type.buildCallingScopeType(new Type[]{Types.FLOATING});
            FunctionCall.Argument applyToArg = (FunctionCall.Argument)this.arguments.getRequiredArgument(functionCall, "apply-to").getOrThrow();
            Expression lambdaBody = ((Lambda)applyToArg.getExpression().isA(Lambda.class).get()).getExpression();
            RealizedExpression expression = (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaScope, lambdaBody).getOrThrow(Problems.foundWith((Object)"apply-to", (Problem[])new Problem[0]));
            boolean applyLogToX = argumentTypes.size() == 3 ? (Boolean)this.arguments.evaluateConstant(context, functionCall, "apply-log-to-x", Boolean.class, (Type)Types.BOOLEAN).getOrThrow() : false;
            LinearContinuousFunctionType returnType = (LinearContinuousFunctionType)new LinearContinuousFunctionType.Builder(context).build(builder -> {
                builder.xType = Types.FLOATING;
                builder.xValues = Doubles.toArray((Collection)xValues);
                builder.yExpression = expression;
                builder.logScale = applyLogToX;
            }).getOrThrow(PROBLEMS.couldNotCreateContinuousFunctionFromYValue(lambdaBody, expression.getResultType()));
            return new FunctionImpl(argumentTypes, returnType);
        });
    }

    public RiskscapeFunction asFunction() {
        return RealizableFunction.asFunction((RealizableFunction)this, (ArgumentList)this.arguments, (Type)LinearContinuousFunctionType.ANY);
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem couldNotCreateContinuousFunctionFromYValue(Expression var1, Type var2);
    }

    private class FunctionImpl
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final LinearContinuousFunctionType returnType;

        public Object call(List<Object> args) {
            ScopedLambdaExpression lambda = (ScopedLambdaExpression)args.get(1);
            return this.returnType.newFunction(lambda);
        }

        @Generated
        public FunctionImpl(List<Type> argumentTypes, LinearContinuousFunctionType returnType) {
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public LinearContinuousFunctionType getReturnType() {
            return this.returnType;
        }
    }
}

