/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.defaults.interp.BilinearContinuousFunctionType;
import nz.org.riskscape.defaults.interp.CreateContinuousFunction;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class CreateBilinearContinuousFunction
implements RealizableFunction {
    static final CreateContinuousFunction.LocalProblems PROBLEMS = (CreateContinuousFunction.LocalProblems)Problems.get(CreateContinuousFunction.LocalProblems.class);
    private final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("x-values", (Type)RSList.create((Type)Types.ANYTHING)), new FunctionArgument("y-values", (Type)RSList.create((Type)Types.ANYTHING)), new FunctionArgument("apply-to", (Type)new LambdaType(new String[]{"x-value", "y-value"})), FunctionCallOptions.options(BilinearContinuousFunctionType.Options.class)});

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            if (argumentTypes.size() < this.arguments.size() - 1 || argumentTypes.size() > this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumberRange(this.arguments.size() - 1, this.arguments.size(), argumentTypes.size()));
            }
            double[] xValues = this.extractSortedValues("x-values", (Type)argumentTypes.get(0), functionCall, context);
            double[] yValues = this.extractSortedValues("y-values", (Type)argumentTypes.get(1), functionCall, context);
            ScopedLambdaType lambdaType = (ScopedLambdaType)Types.findOrThrow((Object)"apply-to", (Type)new ScopedLambdaType(Struct.EMPTY_STRUCT, new String[]{"x", "y"}), (Type)((Type)argumentTypes.get(2)));
            if (lambdaType.getArgs().size() != 2) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get("apply-to"), (Type)lambdaType));
            }
            Struct lambdaScope = lambdaType.buildCallingScopeType(new Type[]{Types.FLOATING, Types.FLOATING});
            FunctionCall.Argument applyToArg = (FunctionCall.Argument)this.arguments.getRequiredArgument(functionCall, "apply-to").getOrThrow();
            Expression lambdaBody = ((Lambda)applyToArg.getExpression().isA(Lambda.class).get()).getExpression();
            RealizedExpression valueExpression = (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaScope, lambdaBody).getOrThrow(Problems.foundWith((Object)"apply-to", (Problem[])new Problem[0]));
            BilinearContinuousFunctionType.Options options = (BilinearContinuousFunctionType.Options)FunctionCallOptions.bindOptionsOrThrow(BilinearContinuousFunctionType.Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall);
            Optional<BilinearContinuousFunctionType.ZeroLoss> zeroLoss = this.getZeroLoss(context, functionCall, valueExpression.getResultType());
            BilinearContinuousFunctionType returnType = (BilinearContinuousFunctionType)new BilinearContinuousFunctionType.Builder(context).build(builder -> {
                builder.valueExpression = valueExpression;
                builder.xValues = xValues;
                builder.yValues = yValues;
                builder.zeroLoss = zeroLoss;
                builder.options = options;
            }).getOrThrow(PROBLEMS.couldNotCreateContinuousFunctionFromYValue(lambdaBody, valueExpression.getResultType()));
            return new FunctionImpl(argumentTypes, returnType);
        });
    }

    private Optional<BilinearContinuousFunctionType.ZeroLoss> getZeroLoss(RealizationContext context, FunctionCall functionCall, Type valueExpressionType) throws ProblemException {
        Tuple optionsTuple;
        Struct.StructMember zeroLossMember;
        Optional boundOptions = FunctionCallOptions.bindTuple((RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall);
        if (boundOptions.isPresent() && (zeroLossMember = (Struct.StructMember)(optionsTuple = (Tuple)((ResultOrProblems)boundOptions.get()).getOrThrow()).getStruct().getMember("zero_loss").orElse(null)) != null) {
            Type zeroLossType = zeroLossMember.getType();
            return Optional.of(new BilinearContinuousFunctionType.ZeroLoss(context.getTypeSet().findEquivalenceCoercer(zeroLossType, valueExpressionType).map(c -> c.apply(optionsTuple.fetch("zero_loss"))).orElseThrow(() -> new ProblemException((Problems)Problems.foundWith((Object)"zero_loss", (Problems)TypeProblems.get().mismatch((Object)"zero_loss", valueExpressionType, zeroLossType))))));
        }
        return Optional.empty();
    }

    private double[] extractSortedValues(String argumentName, Type argType, FunctionCall functionCall, RealizationContext context) throws ProblemException {
        RSList listType = (RSList)Types.findOrThrow((Object)argumentName, (Type)RSList.create((Type)Types.ANYTHING), (Type)argType);
        if (!listType.getMemberType().isNumeric()) {
            throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(argumentName), (Type)argType));
        }
        List collection = (List)this.arguments.getRequiredArgument(functionCall, argumentName).flatMap(arg -> arg.evaluateConstant(context, List.class, (Type)RSList.LIST_ANYTHING).composeProblems((sev, problems) -> Problems.foundWith((Object)argumentName, (List)problems))).getOrThrow();
        double[] values = Doubles.toArray((Collection)collection);
        Arrays.sort(values);
        return values;
    }

    public RiskscapeFunction asFunction() {
        return RealizableFunction.asFunction((RealizableFunction)this, (ArgumentList)this.arguments, (Type)BilinearContinuousFunctionType.ANY_BILINEAR);
    }

    private class FunctionImpl
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final BilinearContinuousFunctionType returnType;

        public Object call(List<Object> args) {
            ScopedLambdaExpression lambda = (ScopedLambdaExpression)args.get(2);
            return this.returnType.newFunction(lambda);
        }

        @Generated
        public FunctionImpl(List<Type> argumentTypes, BilinearContinuousFunctionType returnType) {
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public BilinearContinuousFunctionType getReturnType() {
            return this.returnType;
        }
    }
}

