/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.defaults.interp.BilinearContinuousFunction;
import nz.org.riskscape.defaults.interp.StackableContinuousFunctionType;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeVisitor;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;

public final class BilinearContinuousFunctionType
extends StackableContinuousFunctionType<BilinearContinuousFunction> {
    public static final BilinearContinuousFunctionType ANY_BILINEAR = new BilinearContinuousFunctionType();
    private final RealizedExpression xInterpExpr;
    private final RealizedExpression yInterpExpr;
    private final double[] xValues;
    private final double[] yValues;
    private final Optional<ZeroLoss> zeroLoss;
    private final Options options;

    private BilinearContinuousFunctionType() {
        super(2, null, (Type)Types.FLOATING, false);
        this.xInterpExpr = null;
        this.yInterpExpr = null;
        this.xValues = new double[0];
        this.yValues = new double[0];
        this.zeroLoss = Optional.empty();
        this.options = new Options();
    }

    private BilinearContinuousFunctionType(RealizedExpression valueExpression, RealizedExpression xInterpExpr, RealizedExpression yInterpExpr, double[] xValues, double[] yValues, Optional<ZeroLoss> zeroLoss, Options options) {
        super(2, valueExpression, yInterpExpr.getResultType(), options.compress);
        this.xInterpExpr = xInterpExpr;
        this.yInterpExpr = yInterpExpr;
        this.xValues = xValues;
        this.yValues = yValues;
        this.zeroLoss = zeroLoss;
        this.options = options;
    }

    @Override
    public Object applyTo(Object func, double ... dimensionValues) {
        Object fxy2;
        Object fxy1;
        double gy2;
        BilinearContinuousFunction function = (BilinearContinuousFunction)func;
        double x = dimensionValues[0];
        double y = dimensionValues[1];
        Pair<Double, Double> x1x2 = BilinearContinuousFunctionType.surrounding(x, this.xValues);
        double x1 = (Double)x1x2.getLeft();
        double x2 = (Double)x1x2.getRight();
        Pair<Double, Double> y1y2 = BilinearContinuousFunctionType.surrounding(y, this.yValues);
        double y1 = (Double)y1y2.getLeft();
        double y2 = (Double)y1y2.getRight();
        x = this.withinRange(x, x1, x2);
        y = this.withinRange(y, y1, y2);
        double gx = this.options.applyLogToX ? Math.log(x) : x;
        double gx1 = this.options.applyLogToX ? Math.log(x1) : x1;
        double gx2 = this.options.applyLogToX ? Math.log(x2) : x2;
        double gy = this.options.applyLogToY ? Math.log(y) : y;
        double gy1 = this.options.applyLogToY ? Math.log(y1) : y1;
        double d = gy2 = this.options.applyLogToY ? Math.log(y2) : y2;
        if (x1 == x2) {
            fxy1 = this.xInterpExpr.evaluateValues(new Object[]{1.0, this.computeIfNecessary(x1, y1, function), 0.0, this.computeIfNecessary(x1, y1, function)});
            fxy2 = this.xInterpExpr.evaluateValues(new Object[]{1.0, this.computeIfNecessary(x1, y2, function), 0.0, this.computeIfNecessary(x1, y2, function)});
        } else {
            Object x2y2 = this.computeIfNecessary(x2, y2, function);
            Object x2y1 = this.computeIfNecessary(x2, y1, function);
            Object x1y2 = this.computeIfNecessary(x1, y2, function);
            fxy1 = this.xInterpExpr.evaluateValues(new Object[]{(gx2 - gx) / (gx2 - gx1), this.computeIfNecessary(x1, y1, function), (gx - gx1) / (gx2 - gx1), x2y1});
            fxy2 = this.xInterpExpr.evaluateValues(new Object[]{(gx2 - gx) / (gx2 - gx1), x1y2, (gx - gx1) / (gx2 - gx1), x2y2});
        }
        if (y1 == y2) {
            return this.yInterpExpr.evaluateValues(new Object[]{1.0, fxy1, 0.0, fxy1});
        }
        return this.yInterpExpr.evaluateValues(new Object[]{(gy2 - gy) / (gy2 - gy1), fxy1, (gy - gy1) / (gy2 - gy1), fxy2});
    }

    @Override
    BilinearContinuousFunction newFunction(ScopedLambdaExpression scope) {
        return new BilinearContinuousFunction(scope, this);
    }

    @Override
    public int getSize() {
        return this.xValues.length * this.yValues.length;
    }

    @Override
    public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.format("BilinearContinuousCurve(xvalues=%s, yvalues=%s, returnType=%s)", Doubles.asList((double[])this.xValues), Doubles.asList((double[])this.yValues), this.returnType);
    }

    private Object computeIfNecessary(double x, double y, BilinearContinuousFunction function) {
        return this.getOrComputeValue(function, this.xyToIndex(x, y));
    }

    @Override
    Object getOrComputeValue(BilinearContinuousFunction function, int key) {
        Object existing = this.getValue(function, key);
        if (existing != null) {
            return existing;
        }
        XY xy = this.indexToXY(key);
        if (this.zeroLoss.isPresent() && function.useZeroLoss(xy)) {
            Object zeroLossValue = this.zeroLoss.get().value;
            this.setValue(function, key, zeroLossValue);
            return zeroLossValue;
        }
        Object value = function.evaluate(this.valueExpression, xy.x, xy.y);
        if (this.zeroLoss.isPresent() && Objects.equals(this.zeroLoss.get().value, value)) {
            function.addZeroLoss(xy);
        }
        this.setValue(function, key, value);
        return value;
    }

    XY indexToXY(int index) {
        double x = this.xValues[index % this.xValues.length];
        double y = this.yValues[index / this.xValues.length];
        return new XY(x, y);
    }

    int xyToIndex(double x, double y) {
        int xIdx = Arrays.binarySearch(this.xValues, x);
        int yIdx = Arrays.binarySearch(this.yValues, y);
        if (xIdx == -1 || yIdx == -1) {
            throw new RuntimeException("Not a known point");
        }
        return yIdx * this.xValues.length + xIdx;
    }

    static Pair<Double, Double> surrounding(double value, double[] values) {
        double firstPoint = values[0];
        double lastPoint = values[values.length - 1];
        if (values.length == 1) {
            return Pair.of((Object)firstPoint, (Object)firstPoint);
        }
        if (value <= firstPoint) {
            return Pair.of((Object)firstPoint, (Object)firstPoint);
        }
        if (value >= lastPoint) {
            return Pair.of((Object)lastPoint, (Object)lastPoint);
        }
        for (int i = 1; i < values.length; ++i) {
            double v1 = values[i - 1];
            double v2 = values[i];
            if (v1 == value || v2 == value) {
                return Pair.of((Object)value, (Object)value);
            }
            if (!(value >= v1) || !(value <= v2)) continue;
            return Pair.of((Object)v1, (Object)v2);
        }
        throw new IllegalStateException("should never get here");
    }

    double withinRange(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BilinearContinuousFunctionType)) {
            return false;
        }
        BilinearContinuousFunctionType other = (BilinearContinuousFunctionType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.xValues, other.xValues)) {
            return false;
        }
        if (!Arrays.equals(this.yValues, other.yValues)) {
            return false;
        }
        Options this$options = this.options;
        Options other$options = other.options;
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BilinearContinuousFunctionType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.xValues);
        result = result * 59 + Arrays.hashCode(this.yValues);
        Options $options = this.options;
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    public static class Options {
        @ParameterField
        public boolean applyLogToX = false;
        @ParameterField
        public boolean applyLogToY = false;
        @ParameterField
        public Optional<Object> zeroLoss = Optional.empty();
        @ParameterField
        public boolean compress = false;
    }

    static final class XY {
        final double x;
        final double y;

        @Generated
        public XY(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XY)) {
                return false;
            }
            XY other = (XY)o;
            if (Double.compare(this.x, other.x) != 0) {
                return false;
            }
            return Double.compare(this.y, other.y) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $x = Double.doubleToLongBits(this.x);
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $y = Double.doubleToLongBits(this.y);
            result = result * 59 + (int)($y >>> 32 ^ $y);
            return result;
        }

        @Generated
        public String toString() {
            return "BilinearContinuousFunctionType.XY(x=" + this.x + ", y=" + this.y + ")";
        }
    }

    static class ZeroLoss {
        final Object value;

        @Generated
        public ZeroLoss(Object value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZeroLoss)) {
                return false;
            }
            ZeroLoss other = (ZeroLoss)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$value = this.value;
            Object other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ZeroLoss;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BilinearContinuousFunctionType.ZeroLoss(value=" + String.valueOf(this.value) + ")";
        }
    }

    public static class Builder {
        public final RealizationContext context;
        public RealizedExpression valueExpression;
        public double[] xValues;
        public double[] yValues;
        public Optional<ZeroLoss> zeroLoss;
        public Options options;

        public ResultOrProblems<BilinearContinuousFunctionType> build(Consumer<Builder> setupVisitor) {
            setupVisitor.accept(this);
            return ProblemException.catching(() -> {
                Struct xInterpExprInput = Struct.of((String)"ratio1", (Type)Types.FLOATING, (String)"value1", (Type)this.valueExpression.getResultType(), (String)"ratio2", (Type)Types.FLOATING, (String)"value2", (Type)this.valueExpression.getResultType());
                RealizedExpression xInterpExpr = (RealizedExpression)this.context.getExpressionRealizer().realize((Type)xInterpExprInput, "(ratio1 * value1) + (ratio2 * value2)").getOrThrow();
                Struct yInterpExprInput = Struct.of((String)"ratio1", (Type)Types.FLOATING, (String)"value1", (Type)xInterpExpr.getResultType(), (String)"ratio2", (Type)Types.FLOATING, (String)"value2", (Type)xInterpExpr.getResultType());
                RealizedExpression yInterpExpr = (RealizedExpression)this.context.getExpressionRealizer().realize((Type)yInterpExprInput, "(ratio1 * value1) + (ratio2 * value2)").getOrThrow();
                try {
                    return new BilinearContinuousFunctionType(this.valueExpression, xInterpExpr, yInterpExpr, this.xValues, this.yValues, this.zeroLoss, this.options);
                }
                catch (IllegalArgumentException ex) {
                    throw new ProblemException((Problems)Problems.caught((Throwable)ex));
                }
            });
        }

        public RealizedExpression realize(Struct inputType, String expr) throws ProblemException {
            Expression parsed = ExpressionParser.parseString((String)expr);
            return (RealizedExpression)this.context.getExpressionRealizer().realize((Type)inputType, parsed).getOrThrow();
        }

        @Generated
        public Builder(RealizationContext context) {
            this.context = context;
        }
    }
}

