/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import nz.org.riskscape.defaults.interp.BilinearContinuousFunctionType;
import nz.org.riskscape.defaults.interp.StackableContinuousFunction;
import nz.org.riskscape.defaults.interp.StackableContinuousFunctionType;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.Struct;

final class BilinearContinuousFunction
extends StackableContinuousFunction {
    private final AtomicReference<Double> zeroLossX = new AtomicReference<Double>(Double.NEGATIVE_INFINITY);
    private final AtomicReference<Double> zeroLossY = new AtomicReference<Double>(Double.NEGATIVE_INFINITY);
    private final BinaryOperator<Double> maxValueAccumulator = BinaryOperator.maxBy(Comparator.comparingDouble(x -> x));

    BilinearContinuousFunction(ScopedLambdaExpression lambda, StackableContinuousFunctionType<?> type) {
        super(lambda, type);
    }

    public Object evaluate(RealizedExpression realized, double x, double y) {
        Tuple scope = this.lambda.buildCallingScope((Struct)realized.getInputType(), new Object[]{x, y});
        return realized.evaluate((Object)scope);
    }

    public boolean useZeroLoss(BilinearContinuousFunctionType.XY given) {
        return given.x <= this.zeroLossX.get() && given.y <= this.zeroLossY.get();
    }

    public void addZeroLoss(BilinearContinuousFunctionType.XY given) {
        this.zeroLossX.accumulateAndGet(given.x, this.maxValueAccumulator);
        this.zeroLossY.accumulateAndGet(given.y, this.maxValueAccumulator);
    }
}

