/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.interp;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.defaults.interp.ContinuousFunctionType;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ApplyContinuousFunction
implements RealizableFunction {
    private final ArgumentList arguments = ArgumentList.create((String)"function", (Type)ContinuousFunctionType.ANY, (String)"x-value", (Type)Types.FLOATING, (String)"y-value", (Type)Nullable.FLOATING);

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            if (argumentTypes.size() < this.arguments.size() - 1 || argumentTypes.size() > this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumberRange(this.arguments.size() - 1, this.arguments.size(), argumentTypes.size()));
            }
            Boolean nullable = Nullable.is((Type)((Type)argumentTypes.get(0)));
            ContinuousFunctionType curveType = (ContinuousFunctionType)Types.findOrThrow((Object)"function", (Type)ContinuousFunctionType.ANY, (Type)Nullable.strip((Type)((Type)argumentTypes.get(0))));
            if (argumentTypes.size() != curveType.getDimensions() + 1) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(curveType.getDimensions() + 1, argumentTypes.size()));
            }
            for (int i = 0; i < curveType.getDimensions(); ++i) {
                Type givenValueType = (Type)argumentTypes.get(i + 1);
                if (!Nullable.is((Type)givenValueType) && Number.class.isAssignableFrom(givenValueType.internalType())) continue;
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(i + 1), (Type)givenValueType));
            }
            return new FunctionImpl(curveType, argumentTypes, Nullable.ifTrue((boolean)nullable, (Type)curveType.getReturnType()));
        });
    }

    public RiskscapeFunction asFunction() {
        return RealizableFunction.asFunction((RealizableFunction)this, (ArgumentList)this.arguments, (Type)Types.FLOATING);
    }

    private static class FunctionImpl
    implements RiskscapeFunction {
        private final ContinuousFunctionType curveType;
        private final List<Type> argumentTypes;
        private final Type returnType;

        public Object call(List<Object> args) {
            Object function = args.get(0);
            if (function == null) {
                return null;
            }
            double[] values = new double[this.curveType.dimensions];
            for (int i = 0; i < this.curveType.dimensions; ++i) {
                values[i] = ((Number)args.get(i + 1)).doubleValue();
            }
            return this.curveType.applyTo(function, values);
        }

        @Generated
        public FunctionImpl(ContinuousFunctionType curveType, List<Type> argumentTypes, Type returnType) {
            this.curveType = curveType;
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }
}

