/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.geo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class SegmentLineStringOp {
    public List<LineString> apply(MultiLineString toSegment, double distance) {
        int numLineStrings = toSegment.getNumGeometries();
        ArrayList<List<LineString>> allGeometries = new ArrayList<List<LineString>>(numLineStrings);
        int requiredSize = 0;
        for (int i = 0; i < numLineStrings; ++i) {
            LineString lineString = (LineString)toSegment.getGeometryN(i);
            List<LineString> list = this.apply(lineString, distance);
            allGeometries.add(list);
            requiredSize += list.size();
        }
        ArrayList<LineString> finalList = new ArrayList<LineString>(requiredSize);
        for (List list : allGeometries) {
            finalList.addAll(list);
        }
        return finalList;
    }

    public List<LineString> apply(LineString geometry, double distance) {
        Coordinate lastCut;
        CoordinateSequence originalPoints = geometry.getCoordinateSequence();
        LinkedList<LineString> built = new LinkedList<LineString>();
        LinkedList<Coordinate> collected = new LinkedList<Coordinate>();
        Coordinate lastCoord = lastCut = originalPoints.getCoordinate(0);
        double distanceSoFar = 0.0;
        int idx = 0;
        while (idx < originalPoints.size()) {
            Coordinate curCoord = originalPoints.getCoordinate(idx);
            double distanceBetween = lastCoord.distance(curCoord);
            if ((distanceSoFar += distanceBetween) >= distance) {
                double cutDistance = distance - (distanceSoFar - distanceBetween);
                Coordinate cutPoint = this.findCutPoint(lastCoord, curCoord, cutDistance);
                collected.add(cutPoint);
                built.add(this.build(geometry.getFactory(), collected));
                lastCoord = cutPoint;
                collected.clear();
                distanceSoFar = 0.0;
                boolean addCutPoint = cutPoint.equals((Object)curCoord) ? ++idx < originalPoints.size() : true;
                if (addCutPoint) {
                    collected.add(cutPoint);
                }
                lastCut = cutPoint;
                continue;
            }
            collected.add(curCoord);
            lastCoord = curCoord;
            ++idx;
        }
        if (!collected.isEmpty()) {
            built.add(this.build(geometry.getFactory(), collected));
        }
        return Lists.newArrayList(built);
    }

    private Coordinate findCutPoint(Coordinate from, Coordinate to, double distance) {
        if (distance == 0.0) {
            return from;
        }
        LineSegment segment = new LineSegment(from, to);
        double length = segment.getLength();
        if (distance == length) {
            return to;
        }
        if (length == 0.0) {
            return from;
        }
        double fraction = distance / length;
        return segment.pointAlong(fraction);
    }

    private LineString build(GeometryFactory factory, LinkedList<Coordinate> collected) {
        return factory.createLineString(collected.toArray(new Coordinate[collected.size()]));
    }

    @Generated
    public SegmentLineStringOp() {
    }
}

