/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.geo;

import java.awt.geom.AffineTransform;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.grid.FeatureGrid;
import nz.org.riskscape.engine.grid.FeatureGridCell;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutGeometryByGridOp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CutGeometryByGridOp.class);
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.MATCH_SOURCE_GEOMETRY);
    private final SRIDSet sridSet;
    private final EnumSet<Options> options;

    static GridGeometry2D constructGridGeometry(SRIDSet sridSet, Geometry geometry, double gridDistance, Coordinate alignGridTo) {
        double featureEnvelopeYDelta;
        CoordinateReferenceSystem crs = sridSet.get(geometry);
        Envelope featureEnvelope = geometry.getEnvelopeInternal();
        double featureEnvelopeXDelta = (featureEnvelope.getMinX() - alignGridTo.getX()) % gridDistance;
        if (featureEnvelopeXDelta < 0.0) {
            featureEnvelopeXDelta = gridDistance + featureEnvelopeXDelta;
        }
        if ((featureEnvelopeYDelta = (featureEnvelope.getMinY() - alignGridTo.getY()) % gridDistance) < 0.0) {
            featureEnvelopeYDelta = gridDistance + featureEnvelopeYDelta;
        }
        double featureLowerLeftX = featureEnvelope.getMinX() - featureEnvelopeXDelta;
        double featureLowerLeftY = featureEnvelope.getMinY() - featureEnvelopeYDelta;
        double gridWidth = Math.ceil((featureEnvelope.getMaxX() - featureLowerLeftX) / gridDistance);
        double gridHeight = Math.ceil((featureEnvelope.getMaxY() - featureLowerLeftY) / gridDistance);
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, (int)gridWidth, (int)gridHeight);
        featureEnvelope = new Envelope(featureLowerLeftX, featureLowerLeftX + gridWidth * gridDistance, featureLowerLeftY, featureLowerLeftY + gridHeight * gridDistance);
        double scaleX = featureEnvelope.getWidth() / gridRange.getWidth();
        double scaleY = featureEnvelope.getHeight() / gridRange.getHeight();
        double transX = featureEnvelope.getMinX() - (double)gridRange.x * scaleX;
        double transY = featureEnvelope.getMinY() - (double)gridRange.y * scaleY;
        AffineTransform tr = new AffineTransform(scaleX, 0.0, 0.0, scaleY, transX, transY);
        tr.translate(0.5, 0.5);
        LinearTransform transform = ProjectiveTransform.create((AffineTransform)tr);
        GridGeometry2D grid = new GridGeometry2D((GridEnvelope)gridRange, PixelInCell.CELL_CENTER, (MathTransform)transform, crs, new Hints());
        assert (grid.getEnvelope2D().contains(featureEnvelope));
        return grid;
    }

    public CutGeometryByGridOp(SRIDSet sridSet) {
        this(sridSet, DEFAULT_OPTIONS);
    }

    public List<Geometry> apply(Geometry geometry, double gridDistance) {
        Envelope geomEnv = geometry.getEnvelopeInternal();
        return this.apply(this.buildFeatureGrid(geometry, CutGeometryByGridOp.constructGridGeometry(this.sridSet, geometry, gridDistance, new Coordinate(geomEnv.getMinX(), geomEnv.getMinY()))));
    }

    public List<Geometry> apply(Geometry geometry, double gridDistance, Point origin) {
        if (geometry.getSRID() != origin.getSRID()) {
            log.warn("Geometry (SRID {}) and origin (SRID {}) are in different CRSs", (Object)geometry.getSRID(), (Object)origin.getSRID());
        }
        return this.apply(this.buildFeatureGrid(geometry, CutGeometryByGridOp.constructGridGeometry(this.sridSet, geometry, gridDistance, origin.getCoordinate())));
    }

    private List<Geometry> apply(FeatureGrid featureGrid) {
        LinkedList<Geometry> collected = new LinkedList<Geometry>();
        Iterator cellIterator = featureGrid.cellIterator();
        GeometryFamily expectedFamily = GeometryFamily.from((Geometry)featureGrid.getFeature());
        while (cellIterator.hasNext()) {
            FeatureGridCell cell = (FeatureGridCell)cellIterator.next();
            Geometry cut = cell.computeIntersection();
            if (this.options.contains((Object)Options.MATCH_SOURCE_GEOMETRY)) {
                cut = GeometryUtils.removeNonFamilyMembers((Geometry)cut, (GeometryFamily)expectedFamily);
            }
            if (cut.isEmpty()) continue;
            GeometryUtils.processPerPart((Geometry)cut, c -> collected.add((Geometry)c));
        }
        return collected;
    }

    private FeatureGrid buildFeatureGrid(Geometry polygon, GridGeometry2D gridGeometry) {
        try {
            return new FeatureGrid(polygon, CRS.getAxisOrder((CoordinateReferenceSystem)this.sridSet.get(polygon)), gridGeometry);
        }
        catch (MismatchedDimensionException | TransformException e) {
            throw new RuntimeException("Unexpected error while building grid", e);
        }
    }

    @Generated
    public CutGeometryByGridOp(SRIDSet sridSet, EnumSet<Options> options) {
        this.sridSet = sridSet;
        this.options = options;
    }

    public static enum Options {
        MATCH_SOURCE_GEOMETRY;

    }
}

