/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function.expression;

import java.util.List;
import nz.org.riskscape.defaults.function.expression.ExpressionFunctionFramework;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.function.UserDefinedFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class RealizableExpressionFunction
extends UserDefinedFunction {
    private Lambda lambda;

    public RealizableExpressionFunction(FunctionMetadata details, Resource functionSource, Lambda ast) {
        super(details, functionSource);
        this.lambda = ast;
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        UntypedFunction function;
        Type returnType;
        if (!this.areArgumentsCompatible(context, givenTypes)) {
            return ResultOrProblems.failed((List)this.getArgumentProblems(context, givenTypes));
        }
        if (this.lambda.getArguments().size() != givenTypes.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.lambda.getArguments().size(), givenTypes.size())});
        }
        int index = 0;
        Struct lambdaScope = Struct.EMPTY_STRUCT;
        for (Type type : givenTypes) {
            Token argToken = (Token)this.lambda.getArguments().get(index++);
            lambdaScope = lambdaScope.add(argToken.value, type);
        }
        ResultOrProblems realizedOr = context.getExpressionRealizer().realize((Type)lambdaScope, this.lambda.getExpression());
        if (realizedOr.hasErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().failedToRealize((Expression)this.lambda, (Type)lambdaScope).withChildren(realizedOr.getProblems())});
        }
        RealizedExpression realizedLambda = (RealizedExpression)realizedOr.get();
        Struct finalScope = lambdaScope;
        Type declaredReturnType = this.getMetadata().getReturnType();
        Type inferredReturnType = realizedLambda.getResultType();
        TypeSet typeSet = context.getProject().getTypeSet();
        if (typeSet.isAssignable(inferredReturnType, declaredReturnType)) {
            returnType = inferredReturnType;
            function = args -> realizedLambda.evaluate((Object)Tuple.ofValues((Struct)finalScope, (Object[])args.toArray()));
        } else {
            returnType = declaredReturnType;
            function = args -> {
                Object result = realizedLambda.evaluate((Object)Tuple.ofValues((Struct)finalScope, (Object[])args.toArray()));
                try {
                    return declaredReturnType.coerce(result);
                }
                catch (Exception e) {
                    throw new RiskscapeException((Problems)ExpressionFunctionFramework.PROBLEMS.returnTypeCoercionFailed(result, realizedLambda.getResultType(), declaredReturnType).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
                }
            };
        }
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)((Object)this), givenTypes, (Type)returnType, (UntypedFunction)function, (AutoCloseable[])new AutoCloseable[]{realizedLambda}));
    }
}

