/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function.expression;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import nz.org.riskscape.defaults.function.expression.RealizableExpressionFunction;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BoundJavaParameters;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.FunctionFramework;
import nz.org.riskscape.engine.function.FunctionFrameworkSupport;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.MetadataParams;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.Lambda;

public class ExpressionFunctionFramework
implements FunctionFramework,
FunctionFrameworkSupport {
    private static final ArgumentList NO_ARGS_GIVEN = new ArgumentList(List.of());
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final MetadataParams NONE_GIVEN = ExpressionFunctionFramework.getDefaultParams();
    private final String id = "expression";
    private final JavaParameterSet<MetadataParams> parameterSet = JavaParameterSet.fromBindingInstance(MetadataParams.class, (Object)ExpressionFunctionFramework.getDefaultParams());

    private static MetadataParams getDefaultParams() {
        MetadataParams defaults = new MetadataParams();
        defaults.argumentTypes = NO_ARGS_GIVEN;
        defaults.returnType = Nullable.ANYTHING;
        return defaults;
    }

    public ResultOrProblems<IdentifiedFunction> build(String functionName, Project project, BoundParameters bound) {
        BoundJavaParameters bindResult = this.parameterSet.bindToObject(bound);
        MetadataParams params = (MetadataParams)bindResult.getBoundToObject();
        return this.loadFunctionFromParams(project.getEngine(), params).flatMap(resource -> this.parseFunctionFromResource((Resource)resource).flatMap(parsedLambdaExpression -> this.checkArgsAndBuildMetadata(functionName, (BoundJavaParameters<MetadataParams>)bindResult, (Lambda)parsedLambdaExpression).map(functionMetadata -> new RealizableExpressionFunction((FunctionMetadata)functionMetadata, (Resource)resource, (Lambda)parsedLambdaExpression).identified())));
    }

    private ResultOrProblems<FunctionMetadata> checkArgsAndBuildMetadata(String functionName, BoundJavaParameters<MetadataParams> bindResult, Lambda functionExpression) {
        MetadataParams params = (MetadataParams)bindResult.getBoundToObject();
        ArgumentList givenArgList = params.argumentTypes;
        boolean argTypesParameterGiven = bindResult.getUnbound().containsKey("argument-types");
        if (argTypesParameterGiven) {
            if (givenArgList.size() != functionExpression.getArguments().size()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.argCountMismatch(givenArgList.size(), functionExpression.getArguments().size())});
            }
            if (givenArgList.stream().anyMatch(Predicate.not(FunctionArgument::hasKeyword))) {
                params.argumentTypes = new ArgumentList(givenArgList.stream().map(arg -> this.reKeyArgument((FunctionArgument)arg, functionExpression)).toList());
            }
        } else {
            List<FunctionArgument> formedArgs = functionExpression.getArguments().stream().map(token -> new FunctionArgument(token.getValue(), (Type)Nullable.ANYTHING)).toList();
            params.argumentTypes = new ArgumentList(formedArgs);
        }
        return ResultOrProblems.of((Object)params.toFunctionMetadata(functionName));
    }

    private FunctionArgument reKeyArgument(FunctionArgument arg, Lambda lambda) {
        if (arg.hasKeyword()) {
            return arg;
        }
        return new FunctionArgument(((Token)lambda.getArguments().get(arg.getIndex())).getValue(), arg.getType());
    }

    private ResultOrProblems<Lambda> parseFunctionFromResource(Resource source) {
        Expression expression;
        try {
            expression = ExpressionParser.INSTANCE.parse(source.getContentAsString());
        }
        catch (LexerException | ParseException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
        return expression.isA(Lambda.class).map(ResultOrProblems::of).orElse(ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().mismatch(expression, Lambda.class, "(a, b) -> a + b")}));
    }

    public boolean canBuild(Project project, Map<String, List<?>> unbound) {
        return MetadataParams.locationEndsWith(unbound, (String)".txt");
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public JavaParameterSet<MetadataParams> getParameterSet() {
        return this.parameterSet;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem argCountMismatch(int var1, int var2);

        public Problem returnTypeCoercionFailed(Object var1, Type var2, Type var3);
    }
}

