/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.defaults.lookup.MapLookupTable;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.LookupTableType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ToLookupTable
implements AggregationFunction {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final FunctionImpl function = new FunctionImpl();
    private final ArgumentList arguments = ArgumentList.create((String)"keyExpression", (Type)new LambdaType(new String[]{"listElement"}), (String)"valueExpression", (Type)new LambdaType(new String[]{"listElement"}), (String)"options", (Type)Struct.of((String)"unique", (Type)Types.BOOLEAN));

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return ProblemException.catching(() -> {
            if (fc.getArguments().size() < 2) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, fc.getArguments().size()));
            }
            Options options = (Options)FunctionCallOptions.bindOptions(Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)fc).getOrThrow();
            RealizedExpression keyExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(0)).getExpression()).getOrThrow(Problems.foundWith(fc.getArguments().get(0), (Problem[])new Problem[0]));
            RealizedExpression valueExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(1)).getExpression()).getOrThrow(Problems.foundWith(fc.getArguments().get(1), (Problem[])new Problem[0]));
            Type lookupValueType = options.isUnique() ? valueExpression.getResultType() : RSList.create((Type)valueExpression.getResultType());
            LookupTableType lookupTableType = new LookupTableType(keyExpression.getResultType(), lookupValueType);
            return RealizedAggregateExpression.create((Type)inputType, (Type)lookupTableType, (Expression)fc, () -> new LookupTableAccumulator(keyExpression, valueExpression, options.isUnique()));
        });
    }

    public RiskscapeFunction asRiskscapeFunction() {
        return this.function;
    }

    private class FunctionImpl
    implements RiskscapeFunction,
    RealizableFunction {
        private final RSList expectedType = RSList.create((Type)Struct.of((String)"key", (Type)Types.ANYTHING, (String)"value", (Type)Types.ANYTHING));
        private final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("list", (Type)this.expectedType), new FunctionArgument("options", (Type)Struct.of((String)"unique", (Type)Types.BOOLEAN))});

        private FunctionImpl() {
        }

        public Type getReturnType() {
            return LookupTableType.WILD;
        }

        public List<Type> getArgumentTypes() {
            return this.arguments.getArgumentTypes();
        }

        public Object call(List<Object> args) {
            throw new UnsupportedOperationException();
        }

        public boolean isDoTypeAdaptation() {
            return false;
        }

        public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
            if (argumentTypes.size() < 1) {
                return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), this.arguments.size())});
            }
            return ProblemException.catching(() -> {
                ProblemException listMismatch = new ProblemException((Problems)TypeProblems.get().mismatch(functionCall.getArguments().get(0), (Type)this.expectedType, (Type)argumentTypes.get(0)));
                boolean nullable = Nullable.is((Type)((Type)argumentTypes.get(0)));
                RSList list = (RSList)this.arguments.getRequiredAs(argumentTypes, 0, RSList.class).orElseThrow(() -> listMismatch);
                Struct memberType = (Struct)list.getMemberType().findAllowNull(Struct.class).orElseThrow(() -> listMismatch);
                Options options = (Options)FunctionCallOptions.bindOptions(Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall).getOrThrow();
                Struct.StructMember keyMember = (Struct.StructMember)memberType.getMember("key").orElseThrow(() -> listMismatch);
                Struct.StructMember valueMember = (Struct.StructMember)memberType.getMember("value").orElseThrow(() -> listMismatch);
                Object valueType = options.unique ? valueMember.getType() : RSList.create((Type)valueMember.getType());
                LookupTableType returnType = LookupTableType.create((Type)keyMember.getType(), (Type)valueType);
                return RiskscapeFunction.create((Object)this, (List)argumentTypes, (Type)Nullable.ifTrue((boolean)nullable, (Type)returnType), arg_0 -> FunctionImpl.lambda$realize$5(keyMember, valueMember, options, returnType, (Type)valueType, arg_0), (AutoCloseable[])new AutoCloseable[0]);
            });
        }

        public Optional<AggregationFunction> getAggregationFunction() {
            return Optional.of(ToLookupTable.this);
        }

        @Generated
        public ArgumentList getArguments() {
            return this.arguments;
        }

        private static /* synthetic */ Object lambda$realize$5(Struct.StructMember keyMember, Struct.StructMember valueMember, Options options, LookupTableType returnType, Type valueType, List args) {
            HashMap<Object, Object> values = new HashMap<Object, Object>();
            List toReduce = (List)args.get(0);
            if (toReduce == null) {
                return null;
            }
            for (Object object : toReduce) {
                if (object == null) continue;
                Tuple tuple = (Tuple)object;
                Object key = tuple.fetch(keyMember);
                Object value = tuple.fetch(valueMember);
                if (options.unique) {
                    Object replaced = values.put(key, value);
                    if (replaced == null) continue;
                    throw new RiskscapeException((Problems)PROBLEMS.keyNotUnique(key, Arrays.asList(value, replaced)));
                }
                HashMap<Object, Object> listValues = values;
                List keyedValues = listValues.computeIfAbsent(key, k -> new ArrayList());
                keyedValues.add(value);
            }
            return new MapLookupTable(values, returnType.getKeyType(), valueType);
        }
    }

    public static class Options {
        @ParameterField
        private boolean unique = false;

        @Generated
        public Options() {
        }

        @Generated
        public boolean isUnique() {
            return this.unique;
        }

        @Generated
        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isUnique() == other.isUnique();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUnique() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "ToLookupTable.Options(unique=" + this.isUnique() + ")";
        }
    }

    public static class LookupTableAccumulator
    implements Accumulator {
        private final RealizedExpression keyExpression;
        private final RealizedExpression valueExpression;
        private final boolean unique;
        private final HashMap values = new HashMap();

        public Accumulator combine(Accumulator rhs) {
            LookupTableAccumulator ltRhs = (LookupTableAccumulator)rhs;
            HashMap rhsValues = ltRhs.values;
            for (Map.Entry entry : rhsValues.entrySet()) {
                if (this.unique) {
                    Object replaced = this.values.put(entry.getKey(), entry.getValue());
                    if (replaced == null) continue;
                    throw new RiskscapeException((Problems)PROBLEMS.keyNotUnique(entry.getKey(), Arrays.asList(entry.getValue(), replaced)));
                }
                this.values.merge(entry.getKey(), entry.getValue(), (old, andNew) -> {
                    List oldList = (List)old;
                    List newList = (List)andNew;
                    oldList.addAll(newList);
                    return oldList;
                });
            }
            return this;
        }

        public void accumulate(Object input) {
            Object key = this.keyExpression.evaluate(input);
            Object value = this.valueExpression.evaluate(input);
            if (this.unique) {
                Object replaced = this.values.put(key, value);
                if (replaced != null) {
                    throw new RiskscapeException((Problems)PROBLEMS.keyNotUnique(key, Arrays.asList(value, replaced)));
                }
            } else {
                HashMap listValues = this.values;
                List keyedValues = listValues.computeIfAbsent(key, k -> new ArrayList());
                keyedValues.add(value);
            }
        }

        public Object process() {
            return new MapLookupTable(this.values, this.keyExpression.getResultType(), this.valueExpression.getResultType());
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Generated
        public LookupTableAccumulator(RealizedExpression keyExpression, RealizedExpression valueExpression, boolean unique) {
            this.keyExpression = keyExpression;
            this.valueExpression = valueExpression;
            this.unique = unique;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem keyNotUnique(Object var1, List<Object> var2);
    }
}

