/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.RelationBackedList;
import nz.org.riskscape.engine.util.SegmentedList;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ToListFunction
extends BaseRealizableFunction
implements AggregationFunction {
    public ToListFunction() {
        super(ArgumentList.create((String)"value", (Type)Types.ANYTHING), (Type)RSList.create((Type)Types.ANYTHING));
    }

    public RiskscapeFunction asFunction() {
        return AggregationFunction.addAggregationTo((AggregationFunction)this, (RiskscapeFunction)super.asFunction());
    }

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return this.arguments.getRequiredArgument(fc, "value").flatMap(arg -> context.getExpressionRealizer().realize(inputType, arg.getExpression())).map(realized -> {
            RSList resultType = RSList.create((Type)realized.getResultType());
            return RealizedAggregateExpression.create((Type)inputType, (Type)resultType, (Expression)fc, () -> new AccumImpl((RealizedExpression)realized));
        });
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            if (givenTypes.size() != 1) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(1, givenTypes.size()));
            }
            RelationType relationType = (RelationType)((Type)givenTypes.get(0)).findAllowNull(RelationType.class).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().mismatch((Object)this.arguments.get(0), (Type)RelationType.WILD, (Type)givenTypes.get(0))));
            return RiskscapeFunction.create((Object)((Object)this), (List)givenTypes, (Type)RSList.create((Type)relationType.getContainedType()), args -> new RelationBackedList((Relation)args.get(0), context.getProblemSink()), (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    private static class AccumImpl
    implements Accumulator {
        private final RealizedExpression expression;
        private final List list;

        AccumImpl(RealizedExpression expression) {
            this.expression = expression;
            this.list = SegmentedList.forType((Type)expression.getResultType());
        }

        public Accumulator combine(Accumulator rhs) {
            List rhsList = ((AccumImpl)rhs).list;
            this.list.addAll(rhsList);
            return this;
        }

        public void accumulate(Object input) {
            this.list.add(this.expression.evaluate(input));
        }

        public Object process() {
            return this.list;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

