/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class SwitchFunction
extends BaseRealizableFunction {
    public static final Struct CASE_TYPE = Struct.of((String)"in", (Type)RSList.LIST_ANYTHING, (String)"return", (Type)Types.ANYTHING);
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public SwitchFunction() {
        super(ArgumentList.create((String)"on", (Type)Types.ANYTHING, (String)"default", (Type)Types.ANYTHING, (String)"cases", (Type)RSList.create((Type)CASE_TYPE)), (Type)Types.ANYTHING);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() != this.arguments.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.arguments.size(), givenTypes.size())});
        }
        boolean nullableReturnType = Nullable.is((Type)givenTypes.get(1));
        Type baseReturnType = Nullable.strip((Type)givenTypes.get(1));
        Struct caseType = givenTypes.get(2).find(RSList.class).map(RSList::getContainedType).flatMap(c -> c.find(Struct.class)).orElse(null);
        if (caseType == null || caseType.size() != 2 || !caseType.hasMember("in") || !caseType.hasMember("return")) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.arguments.get(2), (Type)givenTypes.get(2))});
        }
        Type listType = caseType.getEntry("in").getType().find(RSList.class).map(RSList::getContainedType).orElse(null);
        Type onType = Nullable.strip((Type)givenTypes.get(0));
        boolean bl = nullableReturnType = nullableReturnType || Nullable.is((Type)givenTypes.get(0));
        if (onType != listType) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.caseOptionsMustBeSameTypeAsOn(onType, listType)});
        }
        Type caseReturnType = caseType.getEntry("return").getType();
        boolean bl2 = nullableReturnType = nullableReturnType || Nullable.is((Type)caseReturnType);
        if (baseReturnType != Nullable.strip((Type)caseReturnType)) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.caseMustReturnSameTypeAsDefault(baseReturnType, caseType.getEntry("return").getType())});
        }
        Type actualReturnType = Nullable.ifTrue((boolean)nullableReturnType, (Type)baseReturnType);
        return this.getArguments().evaluateConstant(context, functionCall, "cases", List.class, (Type)CASE_TYPE).flatMap(values -> {
            ArrayList<Case> cases = new ArrayList<Case>();
            for (Object value : values) {
                Tuple tuple = (Tuple)value;
                List in = (List)tuple.fetch("in");
                cases.add(new Case(in, tuple.fetch("return")));
            }
            return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)((Object)this), (List)givenTypes, (Type)actualReturnType, args -> {
                Object on = args.get(0);
                if (on == null) {
                    return null;
                }
                for (Case candidate : cases) {
                    if (!candidate.matches(on)) continue;
                    return candidate.result;
                }
                return args.get(1);
            }, (AutoCloseable[])new AutoCloseable[0]));
        });
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem caseOptionsMustBeSameTypeAsOn(Type var1, Type var2);

        public Problem caseMustReturnSameTypeAsDefault(Type var1, Type var2);
    }

    private static class Case {
        final List<Object> values;
        final Object result;

        boolean matches(Object value) {
            return this.values.contains(value);
        }

        @Generated
        public Case(List<Object> values, Object result) {
            this.values = values;
            this.result = result;
        }
    }
}

