/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.ProjectGeometryOp;
import nz.org.riskscape.engine.geo.RecursiveQuadGridOp;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.GeomType;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class SegmentByGrid
extends BaseRealizableFunction {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public SegmentByGrid() {
        super(ArgumentList.create((String)"geometry", (Type)Types.GEOMETRY, (String)"distance", (Type)Types.FLOATING, (String)"align-to", (Type)Types.ANYTHING), (Type)RSList.create((Type)Types.GEOMETRY));
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> types) {
        if (functionCall.getArguments().size() != this.arguments.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.arguments.size(), functionCall.getArguments().size())});
        }
        SRIDSet sridSet = context.getProject().getSridSet();
        RecursiveQuadGridOp cutByGridOp = new RecursiveQuadGridOp();
        Optional pointType = types.get(2).findAllowNull(GeomType.Point.class);
        Optional coverageType = types.get(2).findAllowNull(CoverageType.class);
        if (!pointType.isPresent() && !coverageType.isPresent()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.arguments.get(2), (Type)types.get(2), (List)Lists.newArrayList((Object[])new Type[]{Types.POINT, CoverageType.WILD}))});
        }
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)((Object)this), (List)this.arguments.getArgumentTypes(), (Type)this.returnType, args -> {
            Point alignTo;
            Geometry toSegment = (Geometry)args.get(0);
            Double distance = (Double)args.get(1);
            Object alignToObject = args.get(2);
            if (alignToObject instanceof TypedCoverage) {
                TypedCoverage coverage = (TypedCoverage)alignToObject;
                alignTo = coverage.getEnvelope().map(env -> sridSet.getGeometryFactory(coverage.getCoordinateReferenceSystem()).createPoint(new Coordinate(env.getMinX(), env.getMinY()))).orElseThrow(() -> new RiskscapeException((Problems)PROBLEMS.coverageHasNoEnvelope(coverage)));
            } else {
                alignTo = (Point)alignToObject;
            }
            ProjectGeometryOp projectOp = new ProjectGeometryOp(sridSet);
            return projectOp.apply(toSegment).stream().flatMap(projected -> {
                ArrayList segmented = new ArrayList();
                Point origin = (Point)projected.projectAlso((Geometry)alignTo);
                GeometryUtils.processPerPart((Geometry)projected.getProjected(), geomPart -> segmented.addAll(cutByGridOp.apply(geomPart, distance.doubleValue(), origin)));
                return segmented.stream().map(g -> projected.toSourceCrs(g));
            }).collect(Collectors.toList());
        }, (AutoCloseable[])new AutoCloseable[0]));
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem coverageHasNoEnvelope(TypedCoverage var1);
    }
}

