/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import nz.org.riskscape.defaults.geo.SegmentLineStringOp;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.ProjectGeometryOp;
import nz.org.riskscape.engine.geo.RecursiveQuadGridOp;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class Segment
extends BaseRealizableFunction {
    public Segment() {
        super(ArgumentList.create((String)"geometry", (Type)Types.GEOMETRY, (String)"distance", (Type)Types.FLOATING), (Type)RSList.create((Type)Types.GEOMETRY));
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> types) {
        SRIDSet sridSet = context.getProject().getSridSet();
        SegmentLineStringOp op = new SegmentLineStringOp();
        RecursiveQuadGridOp quadGridOp = new RecursiveQuadGridOp();
        BiFunction<Geometry, Double, List> nonCollection = (geom, distance) -> {
            if (geom instanceof LineString) {
                return op.apply((LineString)geom, (double)distance);
            }
            if (geom instanceof Point) {
                return Collections.singletonList(geom);
            }
            return quadGridOp.apply(geom, distance.doubleValue());
        };
        BiFunction<GeometryCollection, Double, List> collection = (geom, distance) -> {
            int size = geom.getNumGeometries();
            ArrayList<List> chunks = new ArrayList<List>(size);
            int totalSize = 0;
            for (int i = 0; i < size; ++i) {
                Geometry child = geom.getGeometryN(i);
                List childSegments = (List)nonCollection.apply(child, (Double)distance);
                chunks.add(childSegments);
                totalSize += childSegments.size();
            }
            ArrayList collected = new ArrayList(totalSize);
            for (List list : chunks) {
                collected.addAll(list);
            }
            return collected;
        };
        Type myReturnType = this.returnType;
        if (types.size() > 0) {
            myReturnType = types.get(0).findAllowNull(Referenced.class).map(Referenced::getCrs).map(crs -> RSList.create((Type)Referenced.of((Type)Types.GEOMETRY, (CoordinateReferenceSystem)crs))).orElse(myReturnType);
        }
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)((Object)this), (List)this.arguments.getArgumentTypes(), (Type)myReturnType, args -> {
            Geometry toSegment = (Geometry)args.get(0);
            Double distance = (Double)args.get(1);
            ProjectGeometryOp projectOp = new ProjectGeometryOp(sridSet);
            return projectOp.apply(toSegment).stream().flatMap(projected -> {
                List segmented = null;
                segmented = projected.getProjected() instanceof GeometryCollection ? (List)collection.apply((GeometryCollection)projected.getProjected(), distance) : (List)nonCollection.apply(projected.getProjected(), distance);
                return segmented.stream().map(g -> projected.toSourceCrs(g));
            }).collect(Collectors.toList());
        }, (AutoCloseable[])new AutoCloseable[0]));
    }
}

