/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.util.Pair;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class MultiCoverage
implements TypedCoverage {
    private final Struct type;
    private final TypedCoverage[] coverages;
    private final RawValueSetter[] valueSetters;
    private Envelope envelope;
    private final SRIDSet sridSet;
    private final BiFunction<Geometry, Point, List<Geometry>> cutFunction;

    public static MultiCoverage create(Struct type, TypedCoverage[] coverages, RawValueSetter[] valueSetters, SRIDSet sridSet, BiFunction<Geometry, Point, List<Geometry>> cutFunction) {
        if (coverages.length == 0) {
            throw new IllegalArgumentException("can not pass an empty map");
        }
        if (coverages.length != valueSetters.length) {
            throw new IllegalArgumentException("must have same number of coverages and evaluators");
        }
        return new MultiCoverage(type, coverages, valueSetters, sridSet, cutFunction);
    }

    public Object evaluate(Point point) {
        Tuple results = new Tuple(this.type);
        boolean anyResult = false;
        for (int i = 0; i < this.coverages.length; ++i) {
            TypedCoverage coverage = this.coverages[i];
            RawValueSetter valueSetter = this.valueSetters[i];
            Object evaluated = coverage.evaluate(point);
            if (evaluated == null) continue;
            valueSetter.set(evaluated, results);
            anyResult = true;
        }
        return anyResult ? results : null;
    }

    public Optional<Function<Geometry, List<Pair<Geometry, Object>>>> getEvaluateIntersectionOp() {
        return Optional.of(this::evaluateIntersection);
    }

    List<Pair<Geometry, Object>> evaluateIntersection(Geometry geom) {
        Point origin = this.coverages[0].getEnvelope().map(e -> this.getGridOrigin((Envelope)e, this.coverages[0].getCoordinateReferenceSystem())).orElse(this.getGridOrigin(geom.getEnvelopeInternal(), this.sridSet.get(geom)));
        List<Geometry> griddedGeom = this.cutFunction.apply(geom, origin);
        LinkedList<Pair<Geometry, Object>> results = new LinkedList<Pair<Geometry, Object>>();
        for (Geometry gridSegment : griddedGeom) {
            Point point = this.getCentre(gridSegment);
            Tuple tuple = new Tuple(this.type);
            boolean anyResult = false;
            for (int i = 0; i < this.coverages.length; ++i) {
                TypedCoverage coverage = this.coverages[i];
                RawValueSetter valueSetter = this.valueSetters[i];
                Object evaluated = coverage.evaluate(point);
                if (evaluated == null) continue;
                valueSetter.set(evaluated, tuple);
                anyResult = true;
            }
            if (!anyResult) continue;
            results.add((Pair<Geometry, Object>)Pair.of((Object)gridSegment, (Object)tuple));
        }
        return results;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coverages[0].getCoordinateReferenceSystem();
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        if (this.envelope == null) {
            this.envelope = this.coverages[0].getEnvelope().orElse(null);
            if (this.envelope == null) {
                return Optional.empty();
            }
            this.envelope = this.envelope.copy();
            for (int i = 1; i < this.coverages.length; ++i) {
                TypedCoverage typedCoverage = this.coverages[i];
                ReferencedEnvelope expandWith = typedCoverage.getEnvelope().orElse(null);
                if (expandWith == null || !typedCoverage.getCoordinateReferenceSystem().equals(this.getCoordinateReferenceSystem())) continue;
                this.envelope.expandToInclude((Envelope)expandWith);
            }
        }
        return Optional.of(new ReferencedEnvelope(this.envelope, this.getCoordinateReferenceSystem()));
    }

    public String toString() {
        return String.format("MultiCoverage(type=%s)", this.getType());
    }

    public Map<String, TypedCoverage> getCoveragesAsMap() {
        LinkedHashMap<String, TypedCoverage> map = new LinkedHashMap<String, TypedCoverage>();
        List keys = this.type.getMembers();
        for (int i = 0; i < this.coverages.length; ++i) {
            map.put(((Struct.StructMember)keys.get(i)).getKey(), this.coverages[i]);
        }
        return map;
    }

    private Point getGridOrigin(Envelope env, CoordinateReferenceSystem crs) {
        Coordinate origin = new Coordinate(env.getMinX(), env.getMinY());
        return this.sridSet.getGeometryFactory(crs).createPoint(origin);
    }

    private Point getCentre(Geometry geom) {
        return geom.getFactory().createPoint(geom.getEnvelopeInternal().centre());
    }

    @Generated
    private MultiCoverage(Struct type, TypedCoverage[] coverages, RawValueSetter[] valueSetters, SRIDSet sridSet, BiFunction<Geometry, Point, List<Geometry>> cutFunction) {
        this.type = type;
        this.coverages = coverages;
        this.valueSetters = valueSetters;
        this.sridSet = sridSet;
        this.cutFunction = cutFunction;
    }

    @Generated
    public Struct getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface RawValueSetter {
        public void set(Object var1, Tuple var2);
    }
}

