/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.coverage.MappedCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class MapCoverage
extends BaseRealizableFunction {
    public MapCoverage() {
        super(ArgumentList.create((String)"coverage", (Type)CoverageType.WILD, (String)"expression", (Type)new LambdaType(new String[]{"sampled"})), (Type)CoverageType.WILD);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            CoverageType coverageType = (CoverageType)this.arguments.getRequiredAs(argumentTypes, 0, CoverageType.class).getOrThrow();
            ScopedLambdaType lambdaType = (ScopedLambdaType)this.arguments.getRequiredAs(argumentTypes, 1, ScopedLambdaType.class).getOrThrow();
            Lambda lambda = (Lambda)((FunctionCall.Argument)functionCall.getArguments().get(1)).getExpression().isA(Lambda.class).get();
            if (lambdaType.getArity() != 1) {
                throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError((Expression)lambda, lambdaType.getArity(), 1));
            }
            Struct lambdaScopeType = lambdaType.buildCallingScopeType(new Type[]{coverageType.getContainedType()});
            RealizedExpression realizedLambda = (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaScopeType, lambda.getExpression()).getOrThrow();
            Type returnType = Nullable.rewrap((Type)((Type)argumentTypes.get(0)), t -> new CoverageType(realizedLambda.getResultType()));
            return RiskscapeFunction.create((Object)((Object)this), (List)argumentTypes, (Type)returnType, args -> {
                TypedCoverage coverage = (TypedCoverage)args.get(0);
                ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(1);
                Tuple scope = givenLambda.buildCallingScope(lambdaScopeType, new Object[0]);
                if (coverage == null) {
                    return null;
                }
                return new MappedCoverage(coverage, realizedLambda, (String)lambdaType.getArgs().get(0), scope);
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }
}

