/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.lookup.LookupTable;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.LookupTableType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class LookupFunction
implements RealizableFunction,
RiskscapeFunction {
    private final Type returnType = Types.ANYTHING;
    private final ArgumentList arguments = ArgumentList.create((String)"lookuptable", (Type)LookupTableType.WILD, (String)"key", (Type)Types.ANYTHING);
    private final List<Type> argumentTypes = this.arguments.getArgumentTypes();

    public Object call(List<Object> args) {
        throw new UnsupportedOperationException();
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, final List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            if (givenTypes.size() != 2) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, givenTypes.size()));
            }
            final LookupTableType tableType = (LookupTableType)Types.findOrThrow((Object)functionCall, (Type)LookupTableType.WILD, (Type)((Type)givenTypes.get(0)));
            Type givenKeyType = (Type)givenTypes.get(1);
            if (!context.getProject().getTypeSet().isAssignable(givenKeyType, tableType.getKeyType())) {
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)functionCall, tableType.getKeyType(), givenKeyType));
            }
            return new RiskscapeFunction(){

                public Type getReturnType() {
                    return Nullable.of((Type)tableType.getValueType());
                }

                public List<Type> getArgumentTypes() {
                    return givenTypes;
                }

                public Object call(List<Object> args) {
                    LookupTable table = (LookupTable)args.get(0);
                    return table.lookup(args.get(1));
                }
            };
        });
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

