/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.List;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

@Deprecated
public class ListToTuple
extends BaseRealizableFunction {
    public ListToTuple() {
        super(ArgumentList.create((String)"list", (Type)Nullable.of((Type)RSList.LIST_ANYTHING), (String)"upto", (Type)Types.INTEGER, (String)"prefix", (Type)Nullable.TEXT), (Type)Types.ANYTHING);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return super.realize(context, functionCall, givenTypes).withMoreProblems(new Problem[]{GeneralProblems.get().deprecated((Object)"list_to_tuple", (Object)"list_to_columns")});
    }

    public RiskscapeFunction build(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) throws ProblemException {
        RSList listType = (RSList)this.arguments.getRequiredAs(argumentTypes, 0, RSList.class).getOrThrow();
        Long upTo = (Long)this.arguments.get("upto").evaluateConstant(context, functionCall, Long.class).getOrThrow();
        String prefix = "";
        if (argumentTypes.size() == 3) {
            prefix = (String)this.arguments.get("prefix").evaluateConstant(context, functionCall, String.class).getOrThrow();
        }
        if (upTo < 1L) {
            throw new ProblemException((Problems)GeneralProblems.get().valueOutOfRange(this.arguments.getArgument(functionCall, "upto").get(), (Comparable)upTo, Range.atLeast((Comparable)Long.valueOf(1L))));
        }
        Type structMemberType = Nullable.of((Type)listType.getContainedType());
        Struct.StructBuilder builder = new Struct.StructBuilder();
        int i = 0;
        while ((long)i < upTo) {
            builder.add(prefix + i, structMemberType);
            ++i;
        }
        Struct result = builder.build();
        return RiskscapeFunction.create((Object)((Object)this), argumentTypes, (Type)result, args -> {
            List values = (List)args.get(0);
            if (values == null) {
                return new Tuple(result);
            }
            Object[] valueArray = values.toArray();
            if ((long)valueArray.length > upTo) {
                valueArray = Arrays.copyOf(valueArray, upTo.intValue());
            }
            return Tuple.ofValues((Struct)result, (Object[])valueArray);
        }, (AutoCloseable[])new AutoCloseable[0]);
    }
}

