/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class ListToColumns
extends BaseRealizableFunction {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final String OPTIONS_ARG_NAME = "columns";

    public ListToColumns() {
        super(ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("list", Nullable.of((Type)RSList.LIST_ANYTHING)), FunctionCallOptions.options((String)OPTIONS_ARG_NAME, Options.class)}), (Type)Types.ANYTHING);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            int i;
            if (argumentTypes.size() != this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(this.arguments.size(), argumentTypes.size()));
            }
            RSList listType = (RSList)this.arguments.getRequiredAs(argumentTypes, 0, RSList.class).getOrThrow();
            this.arguments.getRequiredArgument(functionCall, OPTIONS_ARG_NAME).getOrThrow();
            Options options = this.getValidatedOptions(functionCall, context);
            if (options.names.isEmpty()) {
                int start = options.startNumbering.orElse(1);
                int end = options.number.get() + options.startNumbering.orElse(1);
                for (i = start; i < end; ++i) {
                    options.names.add(String.valueOf(i));
                }
            }
            Type structMemberType = Nullable.ifTrue((boolean)options.nullable, (Type)listType.getContainedType());
            Struct.StructBuilder builder = new Struct.StructBuilder();
            for (i = 0; i < options.names.size(); ++i) {
                builder.add(options.prefix + options.names.get(i), structMemberType);
            }
            Struct resultType = builder.build();
            return RiskscapeFunction.create((Object)((Object)this), (List)argumentTypes, (Type)resultType, args -> {
                List values = (List)args.get(0);
                if (!(options.nullable || values != null && values.size() >= resultType.size())) {
                    throw new RiskscapeException((Problems)PROBLEMS.insufficientListItemsEncountered(resultType.size(), values == null ? 0 : values.size()));
                }
                if (values == null) {
                    return new Tuple(resultType);
                }
                Object[] valueArray = values.toArray();
                if (valueArray.length > resultType.size()) {
                    valueArray = Arrays.copyOf(valueArray, resultType.size());
                }
                return Tuple.ofValues((Struct)resultType, (Object[])valueArray);
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    private Options getValidatedOptions(FunctionCall functionCall, RealizationContext context) throws ProblemException {
        return (Options)this.arguments.getRequiredArgument(functionCall, OPTIONS_ARG_NAME).flatMap(optionsArg -> FunctionCallOptions.bindOptions((String)OPTIONS_ARG_NAME, Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall)).flatMap(options -> {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            if (options.number.isEmpty() && options.names.isEmpty()) {
                problems.add(ParamProblems.oneOfTheseRequired((String[])new String[]{"number", "names"}));
            } else if (options.number.isPresent() && !options.names.isEmpty()) {
                problems.add(ParamProblems.get().mutuallyExclusive("number", "names"));
            }
            if (options.startNumbering.isPresent() && !options.names.isEmpty()) {
                problems.add(ParamProblems.get().mutuallyExclusive("start_numbering", "names"));
            }
            if (options.number.isPresent() && options.number.get() < 0) {
                problems.add(GeneralProblems.get().valueOutOfRange((Object)"number", (Comparable)((Object)((Number)options.number.get())), Range.atLeast((Comparable)Long.valueOf(0L))));
            }
            return ResultOrProblems.of((Object)options, problems);
        }).getOrThrow(problems -> Problems.foundWith((Object)OPTIONS_ARG_NAME, (Problems)problems));
    }

    public static class Options {
        @ParameterField
        public List<String> names = null;
        @ParameterField
        public String prefix = "";
        @ParameterField
        public Optional<Integer> number = Optional.empty();
        @ParameterField
        public Optional<Integer> startNumbering = Optional.empty();
        @ParameterField
        public boolean nullable = true;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem insufficientListItemsEncountered(int var1, int var2);
    }
}

