/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import nz.org.riskscape.defaults.function.MultiCoverage;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.ProjectGeometryOp;
import nz.org.riskscape.engine.geo.RecursiveQuadGridOp;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class CombineCoverages
extends BaseRealizableFunction {
    private static final Range<Double> GRID_RANGE = Range.greaterThan((Comparable)Double.valueOf(0.0));

    public CombineCoverages() {
        super(ArgumentList.create((String)"coverages", (Type)Types.ANYTHING, (String)"grid-resolution", (Type)Types.FLOATING), (Type)new CoverageType((Type)Struct.EMPTY_STRUCT));
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        SRIDSet sridSet = context.getProject().getSridSet();
        return ProblemException.catching(() -> {
            this.arguments.getRequiredArgument(functionCall, "coverages").getOrThrow();
            Struct components = (Struct)((Type)argumentTypes.get(0)).findAllowNull(Struct.class).get();
            if (components.size() == 0) {
                throw new ProblemException((Problems)TypeProblems.get().structMustBeNonEmpty((Object)"coverages"));
            }
            Struct builtType = this.buildCoverageStruct(components);
            CoverageType newReturnType = new CoverageType((Type)builtType);
            MultiCoverage.RawValueSetter[] valueSetters = this.buildCoverageValueSetters(components);
            this.arguments.getRequiredArgument(functionCall, "grid-resolution").getOrThrow();
            Type gridResType = (Type)argumentTypes.get(1);
            if (!Number.class.isAssignableFrom(gridResType.internalType())) {
                throw new ProblemException((Problems)TypeProblems.get().requiresOneOf((Object)this.getArgument("grid-resolution"), Arrays.asList(Types.INTEGER, Types.FLOATING), gridResType));
            }
            RecursiveQuadGridOp cutOp = new RecursiveQuadGridOp();
            ProjectGeometryOp projOp = new ProjectGeometryOp(sridSet);
            return RiskscapeFunction.create((Object)((Object)this), (List)argumentTypes, (Type)newReturnType, args -> {
                Tuple tuple = (Tuple)args.get(0);
                double gridResolution = ((Number)args.get(1)).doubleValue();
                if (!GRID_RANGE.contains((Comparable)Double.valueOf(gridResolution))) {
                    throw new RiskscapeException((Problems)GeneralProblems.get().valueOutOfRange((Object)this.getArgument("grid-resolution"), (Comparable)Double.valueOf(gridResolution), GRID_RANGE));
                }
                TypedCoverage[] coverages = Arrays.asList(tuple.toArray()).toArray(new TypedCoverage[0]);
                return MultiCoverage.create(builtType, coverages, valueSetters, sridSet, (geom, origin) -> projOp.apply(geom).stream().flatMap(projected -> cutOp.apply(projected.getProjected(), gridResolution, (Point)projected.projectAlso((Geometry)origin)).stream().map(cutGeom -> projected.toSourceCrs(cutGeom))).collect(Collectors.toList()));
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    private Struct buildCoverageStruct(Struct components) throws ProblemException {
        Struct building = Struct.EMPTY_STRUCT;
        for (Struct.StructMember member : components.getMembers()) {
            CoverageType coverageType = member.getType().findAllowNull(CoverageType.class).orElse(null);
            if (coverageType == null) {
                throw new ProblemException((Problems)Problems.foundWith((Object)this.getArgument("coverages"), (Problems)TypeProblems.get().mismatch((Object)member, (Type)CoverageType.WILD, member.getType())));
            }
            String coverageName = member.getKey();
            Optional structOr = coverageType.getMemberType().findAllowNull(Struct.class);
            if (!structOr.isPresent()) {
                building = building.add(member.getKey(), Nullable.of((Type)coverageType.getMemberType()));
                continue;
            }
            Struct child = (Struct)structOr.get();
            for (Struct.StructMember childMember : child.getMembers()) {
                Type childType = childMember.getType();
                if (childType.findAllowNull(Geom.class).isPresent()) continue;
                building = building.add(String.format("%s_%s", coverageName, childMember.getKey()), Nullable.of((Type)childType));
            }
        }
        return building;
    }

    private MultiCoverage.RawValueSetter[] buildCoverageValueSetters(Struct components) throws ProblemException {
        ArrayList<MultiCoverage.RawValueSetter> evaluators = new ArrayList<MultiCoverage.RawValueSetter>();
        AtomicInteger idx = new AtomicInteger();
        for (Struct.StructMember member : components.getMembers()) {
            CoverageType coverageType = member.getType().findAllowNull(CoverageType.class).orElse(null);
            if (coverageType == null) {
                throw new ProblemException((Problems)Problems.foundWith((Object)this.getArgument("coverages"), (Problems)TypeProblems.get().mismatch((Object)member, (Type)CoverageType.WILD, member.getType())));
            }
            Optional structOr = coverageType.getMemberType().findAllowNull(Struct.class);
            int indexAt = idx.get();
            if (!structOr.isPresent()) {
                evaluators.add((value, rawValues) -> rawValues.set(indexAt, value));
                idx.getAndIncrement();
                continue;
            }
            Struct child = (Struct)structOr.get();
            ArrayList<Struct.StructMember> childMembersToInclude = new ArrayList<Struct.StructMember>();
            for (Struct.StructMember childMember : child.getMembers()) {
                Type childType = childMember.getType();
                if (childType.findAllowNull(Geom.class).isPresent()) continue;
                idx.getAndIncrement();
                childMembersToInclude.add(childMember);
            }
            evaluators.add((value, rawValues) -> {
                Tuple tuple = (Tuple)value;
                for (int j = 0; j < childMembersToInclude.size(); ++j) {
                    Struct.StructMember childMember = (Struct.StructMember)childMembersToInclude.get(j);
                    rawValues.set(indexAt + j, tuple.fetch(childMember));
                }
            });
        }
        return evaluators.toArray(new MultiCoverage.RawValueSetter[0]);
    }

    private FunctionArgument getArgument(String name) {
        return this.getArguments().get(name);
    }
}

