/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.StructDeclaration;
import nz.org.riskscape.util.ListUtils;

public class BucketRange
implements AggregationFunction {
    private final AggregationFunction bucketFunction;
    private static final Set<Object> MAX_VALUES = Sets.newHashSet((Object[])new Object[]{Long.MAX_VALUE, Double.POSITIVE_INFINITY, Double.MAX_VALUE});
    private static final Set<Object> MIN_VALUES = Sets.newHashSet((Object[])new Object[]{Long.MIN_VALUE, Double.NEGATIVE_INFINITY, -1.7976931348623157E308});
    private static final List<?> INTEGER_BOUNDS = Arrays.asList(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final List<?> FLOATING_BOUNDS = Arrays.asList(-1.7976931348623157E308, Double.MAX_VALUE);
    private final ArgumentList arguments = ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("pick", (Type)Types.ANYTHING), new FunctionArgument("select", (Type)Types.ANYTHING), new FunctionArgument("range", (Type)RSList.create((Type)Types.ANYTHING)), new FunctionArgument("options", (Type)Nullable.ANYTHING)});

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return ProblemException.catching(() -> {
            Expression rewrittenPickExpression = this.rewritePick(context, inputType, fc);
            boolean addBounds = this.getOption(context, fc, "add_bounds", Boolean.class).orElse(true);
            Expression bucketsExpression = this.createBucketExpression(context, (FunctionCall.Argument)this.arguments.getRequiredArgument(fc, "range").getOrThrow(), addBounds);
            FunctionCall newFunctionCall = new FunctionCall(fc.getIdentifier(), Arrays.asList(new FunctionCall.Argument(rewrittenPickExpression, "pick"), new FunctionCall.Argument(((FunctionCall.Argument)this.arguments.getRequiredArgument(fc, "select").getOrThrow()).getExpression(), "select"), new FunctionCall.Argument(bucketsExpression, "buckets")));
            return (RealizedAggregateExpression)this.bucketFunction.realize(context, inputType, newFunctionCall).getOrThrow();
        });
    }

    private <T> Optional<T> getOption(RealizationContext context, FunctionCall fc, String key, Class<T> expected) throws ProblemException {
        Map options = ((Tuple)this.arguments.getArgument(fc, "options").map(arg -> arg.evaluateConstant(context, Tuple.class, (Type)Struct.EMPTY_STRUCT)).orElse(ResultOrProblems.of((Object)Tuple.EMPTY_TUPLE)).orElse((Object)Tuple.EMPTY_TUPLE)).toMap();
        Object value = options.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!expected.isInstance(value)) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get("options"), (Problems)TypeProblems.get().mismatch(value, expected, value.getClass())));
        }
        return Optional.of(expected.cast(value));
    }

    private Expression asExpression(Object obj) {
        return ExpressionParser.INSTANCE.parse(obj.toString());
    }

    private Expression createBucketExpression(RealizationContext context, FunctionCall.Argument argument, boolean addBounds) throws ProblemException {
        int minValues;
        List values = (ArrayList)argument.evaluateConstant(context, List.class, (Type)RSList.LIST_ANYTHING).getOrThrow(Problems.foundWith((Object)this.arguments.get("range"), (Problem[])new Problem[0]));
        int n = minValues = addBounds ? 1 : 2;
        if (values.size() < minValues) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get("range"), (Problems)GeneralProblems.get().badListLength(minValues + "+", values.size())));
        }
        RealizedExpression realized = (RealizedExpression)context.getExpressionRealizer().realizeConstant(argument.getExpression()).getOrThrow();
        Type memberType = realized.getResultType().find(RSList.class).map(list -> list.getMemberType()).orElse((Type)Types.ANYTHING);
        if (!memberType.isNumeric()) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get("range"), (Problems)TypeProblems.get().listItemMismatch(Number.class, memberType)));
        }
        if (addBounds) {
            for (Object limit : memberType == Types.INTEGER ? INTEGER_BOUNDS : FLOATING_BOUNDS) {
                if (values.contains(limit)) continue;
                values = ListUtils.append(values, limit);
            }
        }
        if (!(values instanceof ArrayList)) {
            values = new ArrayList(values);
        }
        values.sort((lhs, rhs) -> ((Comparable)lhs).compareTo(rhs));
        ArrayList<StructDeclaration.Member> bucketMembers = new ArrayList<StructDeclaration.Member>(values.size() - 1);
        for (int i = 0; i < values.size() - 1; ++i) {
            String leftLabel = this.valueLabel(values.get(i));
            Expression left = this.asExpression(values.get(i));
            String rightLabel = this.valueLabel(values.get(i + 1));
            Expression right = this.asExpression(values.get(i + 1));
            String label = "range_" + leftLabel + "_" + rightLabel;
            StructDeclaration rangeExpression = new StructDeclaration(Arrays.asList(StructDeclaration.jsonStyleMember((String)"start", (Expression)left), StructDeclaration.jsonStyleMember((String)"end", (Expression)right)), Optional.empty());
            bucketMembers.add(StructDeclaration.jsonStyleMember((String)label, (Expression)rangeExpression));
        }
        return new StructDeclaration(bucketMembers, Optional.empty());
    }

    private String valueLabel(Object toLabel) {
        if (MAX_VALUES.contains(toLabel)) {
            return "+";
        }
        if (MIN_VALUES.contains(toLabel)) {
            return "<";
        }
        return toLabel.toString().replace('.', '_');
    }

    private Expression rewritePick(RealizationContext context, Type inputType, FunctionCall fc) throws ProblemException {
        RealizedExpression realized = (RealizedExpression)this.arguments.get("pick").mapFunctionCall(fc, arg -> context.getExpressionRealizer().realize(inputType, arg.getExpression())).getOrThrow();
        if (!realized.getResultType().isNumeric()) {
            throw new ProblemException((Problems)ArgsProblems.get().notNumeric(this.arguments.get(0), realized.getResultType()));
        }
        return ExpressionParser.parseString((String)String.format("bucket -> (%s) >= bucket.start && (%s) < bucket.end", realized.getExpression().toSource(), realized.getExpression().toSource()));
    }

    @Generated
    public BucketRange(AggregationFunction bucketFunction) {
        this.bucketFunction = bucketFunction;
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }
}

