/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.function;

import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class BucketFunction
implements AggregationFunction {
    private final ArgumentList arguments = ArgumentList.create((String)"select", (Type)Types.ANYTHING, (String)"pick", (Type)new LambdaType(new String[]{"aggregation_value"}), (String)"buckets", (Type)Struct.EMPTY_STRUCT);

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return ProblemException.catching(() -> {
            RealizedAggregateExpression selectExpression = (RealizedAggregateExpression)this.arguments.get("select").mapFunctionCall(fc, arg -> context.getExpressionRealizer().realizeAggregate(inputType, arg.getExpression())).getOrThrow();
            Tuple buckets = (Tuple)this.arguments.get("buckets").evaluateConstant(context, fc, Tuple.class).getOrThrow();
            Type aggregateResultType = Nullable.ifTrue((boolean)selectExpression.newAccumulator().isEmpty(), (Type)selectExpression.getResultType());
            Struct.StructBuilder resultTypeBuilder = Struct.builder();
            for (Struct.StructMember member : buckets.getStruct().getMembers()) {
                resultTypeBuilder.add(member.getKey(), aggregateResultType);
            }
            Struct resultType = resultTypeBuilder.build();
            Expression givenPickExpression = ((FunctionCall.Argument)this.arguments.getRequiredArgument(fc, "pick").getOrThrow()).getExpression();
            Lambda pick = givenPickExpression.isA(Lambda.class).orElse(null);
            if (pick == null) {
                throw new ProblemException((Problems)ExpressionProblems.get().mismatch(givenPickExpression, Lambda.class, "bucket_value -> exposure.category = bucket_value"));
            }
            if (pick.getArguments().size() != 1) {
                throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError(givenPickExpression, pick.getArguments().size(), 1));
            }
            Type bucketType = buckets.getStruct().getMembers().stream().map(Struct.StructMember::getType).findFirst().orElse((Type)Types.NOTHING);
            for (Struct.StructMember bucketsMember : buckets.getStruct().getMembers()) {
                if (bucketsMember.getType().equals(bucketType)) continue;
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)("bucket " + bucketsMember.getKey()), bucketType, bucketsMember.getType()));
            }
            Struct lambdaScopeType = ((Struct)inputType.find(Struct.class).get()).add(((Token)pick.getArguments().get((int)0)).value, bucketType);
            RealizedExpression pickLambda = (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaScopeType, pick.getExpression()).getOrThrow(Problems.foundWith((Object)this.arguments.get("pick"), (Problem[])new Problem[0]));
            Types.findOrThrow((Object)"pick return type", (Type)Types.BOOLEAN, (Type)Nullable.strip((Type)pickLambda.getResultType()));
            return RealizedAggregateExpression.create((Type)inputType, (Type)resultType, (Expression)fc, () -> new AccumImpl(resultType, selectExpression, pickLambda, buckets));
        });
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    private static class AccumImpl
    implements Accumulator {
        private final int size;
        private final Accumulator[] bucketAccumulators;
        private final RealizedExpression pickExpr;
        private final Tuple buckets;
        private final Tuple pickInput;
        private final Struct resultType;
        private int inputSize;

        AccumImpl(Struct resultType, RealizedAggregateExpression selectExpr, RealizedExpression pickExpr, Tuple buckets) {
            this.size = resultType.size();
            this.resultType = resultType;
            this.bucketAccumulators = new Accumulator[this.size];
            this.pickExpr = pickExpr;
            this.pickInput = new Tuple((Struct)pickExpr.getInputType());
            this.buckets = buckets;
            for (int i = 0; i < this.size; ++i) {
                this.bucketAccumulators[i] = selectExpr.newAccumulator();
            }
            this.inputSize = ((Struct)selectExpr.getInputType().find(Struct.class).get()).size();
        }

        public Accumulator combine(Accumulator rhsObject) {
            AccumImpl rhs = (AccumImpl)rhsObject;
            for (int i = 0; i < this.size; ++i) {
                this.bucketAccumulators[i] = this.bucketAccumulators[i].combine(rhs.bucketAccumulators[i]);
            }
            return this;
        }

        public void accumulate(Object input) {
            Tuple inputTuple = (Tuple)input;
            this.pickInput.setAll(inputTuple);
            for (int i = 0; i < this.size; ++i) {
                this.pickInput.set(this.inputSize, this.buckets.fetch(i));
                if (!Boolean.TRUE.equals(this.pickExpr.evaluate((Object)this.pickInput))) continue;
                this.bucketAccumulators[i].accumulate(input);
            }
        }

        public Object process() {
            Tuple result = new Tuple(this.resultType);
            for (int i = 0; i < this.size; ++i) {
                Accumulator bucketAccum = this.bucketAccumulators[i];
                if (bucketAccum.isEmpty()) continue;
                result.set(i, bucketAccum.process());
            }
            return result;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

