/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.defaults.curves;

import java.util.Collections;
import java.util.List;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.FunctionType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class TrapezoidIntegrationFunction
extends BaseRealizableFunction {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public TrapezoidIntegrationFunction() {
        super(ArgumentList.create((String)"function", (Type)FunctionType.WILD, (String)"a", (Type)Types.FLOATING, (String)"b", (Type)Types.FLOATING, (String)"intervals", (Type)Types.INTEGER), (Type)Types.FLOATING);
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            FunctionType functionType = (FunctionType)Types.findOrThrow((Object)this.arguments.get("function"), (Type)FunctionType.WILD, (Type)((Type)argumentTypes.get(0)));
            if (functionType.getArgumentTypes().size() != 1 || functionType.getArgumentTypes().get(0) != Types.FLOATING) {
                throw new ProblemException((Problems)PROBLEMS.functionBadArgumentTypes(functionType.getArgumentTypes()));
            }
            if (!functionType.getReturnType().isNumeric()) {
                throw new ProblemException((Problems)PROBLEMS.functionBadReturnType(functionType.getReturnType()));
            }
            Types.findOrThrow((Object)this.arguments.get("a"), (Type)Types.FLOATING, (Type)((Type)argumentTypes.get(1)));
            Types.findOrThrow((Object)this.arguments.get("b"), (Type)Types.FLOATING, (Type)((Type)argumentTypes.get(2)));
            Types.findOrThrow((Object)this.arguments.get("intervals"), (Type)Types.INTEGER, (Type)((Type)argumentTypes.get(3)));
            return RiskscapeFunction.create((Object)((Object)this), (List)argumentTypes, (Type)Types.FLOATING, args -> {
                UntypedFunction integrating = (UntypedFunction)args.get(0);
                double a = ((Number)args.get(1)).doubleValue();
                double b = ((Number)args.get(2)).doubleValue();
                double intervals = ((Number)args.get(3)).doubleValue();
                double spacing = Math.abs(b - a) / intervals;
                double sum = 0.0;
                double lastX = Math.min(a, b);
                Double lastY = null;
                int i = 0;
                while ((double)i < intervals) {
                    double x1 = lastX;
                    double x2 = lastX + spacing;
                    double y1 = lastY == null ? ((Number)integrating.call(Collections.singletonList(x1))).doubleValue() : lastY.doubleValue();
                    double y2 = ((Number)integrating.call(Collections.singletonList(x2))).doubleValue();
                    sum += (y1 + y2) / 2.0;
                    lastX = x2;
                    lastY = y2;
                    ++i;
                }
                return sum * spacing;
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem functionBadArgumentTypes(List<Type> var1);

        public Problem functionBadReturnType(Type var1);
    }
}

